// NOTE: File has been autogenerated by utils/aarch64_builtins_test_generator.py
// RUN: %clang_cc1 %s -fsyntax-only -triple aarch64-none-linux-gnu -target-feature +fp8fma -target-feature +sme -target-feature +sve -target-feature +sve2 -verify=guard
// RUN: %clang_cc1 %s -fsyntax-only -triple aarch64-none-linux-gnu -target-feature +sme -target-feature +ssve-fp8fma -target-feature +sve -verify=streaming-guard
// RUN: %clang_cc1 %s -fsyntax-only -triple aarch64-none-linux-gnu -target-feature +fp8fma -target-feature +sme -target-feature +ssve-fp8fma -target-feature +sve -target-feature +sve2 -verify
// expected-no-diagnostics

// REQUIRES: aarch64-registered-target

#include <arm_sve.h>

// Properties: guard="sve,sve2,fp8fma" streaming_guard="sme,ssve-fp8fma" flags="feature-dependent"

void test(void) {
  fpm_t fpm_t_val;
  mfloat8_t mfloat8_t_val;
  svfloat16_t svfloat16_t_val;
  svfloat32_t svfloat32_t_val;
  svmfloat8_t svmfloat8_t_val;

  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmlalb_f16_mf8_fpm(svfloat16_t_val, svmfloat8_t_val, svmfloat8_t_val, fpm_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmlalb_fpm(svfloat16_t_val, svmfloat8_t_val, mfloat8_t_val, fpm_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmlalb_fpm(svfloat16_t_val, svmfloat8_t_val, svmfloat8_t_val, fpm_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmlalb_lane_f16_mf8_fpm(svfloat16_t_val, svmfloat8_t_val, svmfloat8_t_val, 2, fpm_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmlalb_lane_fpm(svfloat16_t_val, svmfloat8_t_val, svmfloat8_t_val, 2, fpm_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmlalb_n_f16_mf8_fpm(svfloat16_t_val, svmfloat8_t_val, mfloat8_t_val, fpm_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmlallbb_f32_mf8_fpm(svfloat32_t_val, svmfloat8_t_val, svmfloat8_t_val, fpm_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmlallbb_fpm(svfloat32_t_val, svmfloat8_t_val, mfloat8_t_val, fpm_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmlallbb_fpm(svfloat32_t_val, svmfloat8_t_val, svmfloat8_t_val, fpm_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmlallbb_lane_f32_mf8_fpm(svfloat32_t_val, svmfloat8_t_val, svmfloat8_t_val, 2, fpm_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmlallbb_lane_fpm(svfloat32_t_val, svmfloat8_t_val, svmfloat8_t_val, 2, fpm_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmlallbb_n_f32_mf8_fpm(svfloat32_t_val, svmfloat8_t_val, mfloat8_t_val, fpm_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmlallbt_f32_mf8_fpm(svfloat32_t_val, svmfloat8_t_val, svmfloat8_t_val, fpm_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmlallbt_fpm(svfloat32_t_val, svmfloat8_t_val, mfloat8_t_val, fpm_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmlallbt_fpm(svfloat32_t_val, svmfloat8_t_val, svmfloat8_t_val, fpm_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmlallbt_lane_f32_mf8_fpm(svfloat32_t_val, svmfloat8_t_val, svmfloat8_t_val, 2, fpm_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmlallbt_lane_fpm(svfloat32_t_val, svmfloat8_t_val, svmfloat8_t_val, 2, fpm_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmlallbt_n_f32_mf8_fpm(svfloat32_t_val, svmfloat8_t_val, mfloat8_t_val, fpm_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmlalltb_f32_mf8_fpm(svfloat32_t_val, svmfloat8_t_val, svmfloat8_t_val, fpm_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmlalltb_fpm(svfloat32_t_val, svmfloat8_t_val, mfloat8_t_val, fpm_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmlalltb_fpm(svfloat32_t_val, svmfloat8_t_val, svmfloat8_t_val, fpm_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmlalltb_lane_f32_mf8_fpm(svfloat32_t_val, svmfloat8_t_val, svmfloat8_t_val, 2, fpm_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmlalltb_lane_fpm(svfloat32_t_val, svmfloat8_t_val, svmfloat8_t_val, 2, fpm_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmlalltb_n_f32_mf8_fpm(svfloat32_t_val, svmfloat8_t_val, mfloat8_t_val, fpm_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmlalltt_f32_mf8_fpm(svfloat32_t_val, svmfloat8_t_val, svmfloat8_t_val, fpm_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmlalltt_fpm(svfloat32_t_val, svmfloat8_t_val, mfloat8_t_val, fpm_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmlalltt_fpm(svfloat32_t_val, svmfloat8_t_val, svmfloat8_t_val, fpm_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmlalltt_lane_f32_mf8_fpm(svfloat32_t_val, svmfloat8_t_val, svmfloat8_t_val, 2, fpm_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmlalltt_lane_fpm(svfloat32_t_val, svmfloat8_t_val, svmfloat8_t_val, 2, fpm_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmlalltt_n_f32_mf8_fpm(svfloat32_t_val, svmfloat8_t_val, mfloat8_t_val, fpm_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmlalt_f16_mf8_fpm(svfloat16_t_val, svmfloat8_t_val, svmfloat8_t_val, fpm_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmlalt_fpm(svfloat16_t_val, svmfloat8_t_val, mfloat8_t_val, fpm_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmlalt_fpm(svfloat16_t_val, svmfloat8_t_val, svmfloat8_t_val, fpm_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmlalt_lane_f16_mf8_fpm(svfloat16_t_val, svmfloat8_t_val, svmfloat8_t_val, 2, fpm_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmlalt_lane_fpm(svfloat16_t_val, svmfloat8_t_val, svmfloat8_t_val, 2, fpm_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmlalt_n_f16_mf8_fpm(svfloat16_t_val, svmfloat8_t_val, mfloat8_t_val, fpm_t_val);
}

void test_streaming(void) __arm_streaming{
  fpm_t fpm_t_val;
  mfloat8_t mfloat8_t_val;
  svfloat16_t svfloat16_t_val;
  svfloat32_t svfloat32_t_val;
  svmfloat8_t svmfloat8_t_val;

  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svmlalb_f16_mf8_fpm(svfloat16_t_val, svmfloat8_t_val, svmfloat8_t_val, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svmlalb_fpm(svfloat16_t_val, svmfloat8_t_val, mfloat8_t_val, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svmlalb_fpm(svfloat16_t_val, svmfloat8_t_val, svmfloat8_t_val, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svmlalb_lane_f16_mf8_fpm(svfloat16_t_val, svmfloat8_t_val, svmfloat8_t_val, 2, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svmlalb_lane_fpm(svfloat16_t_val, svmfloat8_t_val, svmfloat8_t_val, 2, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svmlalb_n_f16_mf8_fpm(svfloat16_t_val, svmfloat8_t_val, mfloat8_t_val, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svmlallbb_f32_mf8_fpm(svfloat32_t_val, svmfloat8_t_val, svmfloat8_t_val, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svmlallbb_fpm(svfloat32_t_val, svmfloat8_t_val, mfloat8_t_val, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svmlallbb_fpm(svfloat32_t_val, svmfloat8_t_val, svmfloat8_t_val, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svmlallbb_lane_f32_mf8_fpm(svfloat32_t_val, svmfloat8_t_val, svmfloat8_t_val, 2, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svmlallbb_lane_fpm(svfloat32_t_val, svmfloat8_t_val, svmfloat8_t_val, 2, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svmlallbb_n_f32_mf8_fpm(svfloat32_t_val, svmfloat8_t_val, mfloat8_t_val, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svmlallbt_f32_mf8_fpm(svfloat32_t_val, svmfloat8_t_val, svmfloat8_t_val, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svmlallbt_fpm(svfloat32_t_val, svmfloat8_t_val, mfloat8_t_val, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svmlallbt_fpm(svfloat32_t_val, svmfloat8_t_val, svmfloat8_t_val, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svmlallbt_lane_f32_mf8_fpm(svfloat32_t_val, svmfloat8_t_val, svmfloat8_t_val, 2, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svmlallbt_lane_fpm(svfloat32_t_val, svmfloat8_t_val, svmfloat8_t_val, 2, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svmlallbt_n_f32_mf8_fpm(svfloat32_t_val, svmfloat8_t_val, mfloat8_t_val, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svmlalltb_f32_mf8_fpm(svfloat32_t_val, svmfloat8_t_val, svmfloat8_t_val, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svmlalltb_fpm(svfloat32_t_val, svmfloat8_t_val, mfloat8_t_val, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svmlalltb_fpm(svfloat32_t_val, svmfloat8_t_val, svmfloat8_t_val, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svmlalltb_lane_f32_mf8_fpm(svfloat32_t_val, svmfloat8_t_val, svmfloat8_t_val, 2, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svmlalltb_lane_fpm(svfloat32_t_val, svmfloat8_t_val, svmfloat8_t_val, 2, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svmlalltb_n_f32_mf8_fpm(svfloat32_t_val, svmfloat8_t_val, mfloat8_t_val, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svmlalltt_f32_mf8_fpm(svfloat32_t_val, svmfloat8_t_val, svmfloat8_t_val, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svmlalltt_fpm(svfloat32_t_val, svmfloat8_t_val, mfloat8_t_val, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svmlalltt_fpm(svfloat32_t_val, svmfloat8_t_val, svmfloat8_t_val, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svmlalltt_lane_f32_mf8_fpm(svfloat32_t_val, svmfloat8_t_val, svmfloat8_t_val, 2, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svmlalltt_lane_fpm(svfloat32_t_val, svmfloat8_t_val, svmfloat8_t_val, 2, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svmlalltt_n_f32_mf8_fpm(svfloat32_t_val, svmfloat8_t_val, mfloat8_t_val, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svmlalt_f16_mf8_fpm(svfloat16_t_val, svmfloat8_t_val, svmfloat8_t_val, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svmlalt_fpm(svfloat16_t_val, svmfloat8_t_val, mfloat8_t_val, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svmlalt_fpm(svfloat16_t_val, svmfloat8_t_val, svmfloat8_t_val, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svmlalt_lane_f16_mf8_fpm(svfloat16_t_val, svmfloat8_t_val, svmfloat8_t_val, 2, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svmlalt_lane_fpm(svfloat16_t_val, svmfloat8_t_val, svmfloat8_t_val, 2, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svmlalt_n_f16_mf8_fpm(svfloat16_t_val, svmfloat8_t_val, mfloat8_t_val, fpm_t_val);
}

void test_streaming_compatible(void) __arm_streaming_compatible{
  fpm_t fpm_t_val;
  mfloat8_t mfloat8_t_val;
  svfloat16_t svfloat16_t_val;
  svfloat32_t svfloat32_t_val;
  svmfloat8_t svmfloat8_t_val;

  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmlalb_f16_mf8_fpm(svfloat16_t_val, svmfloat8_t_val, svmfloat8_t_val, fpm_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmlalb_fpm(svfloat16_t_val, svmfloat8_t_val, mfloat8_t_val, fpm_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmlalb_fpm(svfloat16_t_val, svmfloat8_t_val, svmfloat8_t_val, fpm_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmlalb_lane_f16_mf8_fpm(svfloat16_t_val, svmfloat8_t_val, svmfloat8_t_val, 2, fpm_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmlalb_lane_fpm(svfloat16_t_val, svmfloat8_t_val, svmfloat8_t_val, 2, fpm_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmlalb_n_f16_mf8_fpm(svfloat16_t_val, svmfloat8_t_val, mfloat8_t_val, fpm_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmlallbb_f32_mf8_fpm(svfloat32_t_val, svmfloat8_t_val, svmfloat8_t_val, fpm_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmlallbb_fpm(svfloat32_t_val, svmfloat8_t_val, mfloat8_t_val, fpm_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmlallbb_fpm(svfloat32_t_val, svmfloat8_t_val, svmfloat8_t_val, fpm_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmlallbb_lane_f32_mf8_fpm(svfloat32_t_val, svmfloat8_t_val, svmfloat8_t_val, 2, fpm_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmlallbb_lane_fpm(svfloat32_t_val, svmfloat8_t_val, svmfloat8_t_val, 2, fpm_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmlallbb_n_f32_mf8_fpm(svfloat32_t_val, svmfloat8_t_val, mfloat8_t_val, fpm_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmlallbt_f32_mf8_fpm(svfloat32_t_val, svmfloat8_t_val, svmfloat8_t_val, fpm_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmlallbt_fpm(svfloat32_t_val, svmfloat8_t_val, mfloat8_t_val, fpm_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmlallbt_fpm(svfloat32_t_val, svmfloat8_t_val, svmfloat8_t_val, fpm_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmlallbt_lane_f32_mf8_fpm(svfloat32_t_val, svmfloat8_t_val, svmfloat8_t_val, 2, fpm_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmlallbt_lane_fpm(svfloat32_t_val, svmfloat8_t_val, svmfloat8_t_val, 2, fpm_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmlallbt_n_f32_mf8_fpm(svfloat32_t_val, svmfloat8_t_val, mfloat8_t_val, fpm_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmlalltb_f32_mf8_fpm(svfloat32_t_val, svmfloat8_t_val, svmfloat8_t_val, fpm_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmlalltb_fpm(svfloat32_t_val, svmfloat8_t_val, mfloat8_t_val, fpm_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmlalltb_fpm(svfloat32_t_val, svmfloat8_t_val, svmfloat8_t_val, fpm_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmlalltb_lane_f32_mf8_fpm(svfloat32_t_val, svmfloat8_t_val, svmfloat8_t_val, 2, fpm_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmlalltb_lane_fpm(svfloat32_t_val, svmfloat8_t_val, svmfloat8_t_val, 2, fpm_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmlalltb_n_f32_mf8_fpm(svfloat32_t_val, svmfloat8_t_val, mfloat8_t_val, fpm_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmlalltt_f32_mf8_fpm(svfloat32_t_val, svmfloat8_t_val, svmfloat8_t_val, fpm_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmlalltt_fpm(svfloat32_t_val, svmfloat8_t_val, mfloat8_t_val, fpm_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmlalltt_fpm(svfloat32_t_val, svmfloat8_t_val, svmfloat8_t_val, fpm_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmlalltt_lane_f32_mf8_fpm(svfloat32_t_val, svmfloat8_t_val, svmfloat8_t_val, 2, fpm_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmlalltt_lane_fpm(svfloat32_t_val, svmfloat8_t_val, svmfloat8_t_val, 2, fpm_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmlalltt_n_f32_mf8_fpm(svfloat32_t_val, svmfloat8_t_val, mfloat8_t_val, fpm_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmlalt_f16_mf8_fpm(svfloat16_t_val, svmfloat8_t_val, svmfloat8_t_val, fpm_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmlalt_fpm(svfloat16_t_val, svmfloat8_t_val, mfloat8_t_val, fpm_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmlalt_fpm(svfloat16_t_val, svmfloat8_t_val, svmfloat8_t_val, fpm_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmlalt_lane_f16_mf8_fpm(svfloat16_t_val, svmfloat8_t_val, svmfloat8_t_val, 2, fpm_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmlalt_lane_fpm(svfloat16_t_val, svmfloat8_t_val, svmfloat8_t_val, 2, fpm_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmlalt_n_f16_mf8_fpm(svfloat16_t_val, svmfloat8_t_val, mfloat8_t_val, fpm_t_val);
}
