// NOTE: File has been autogenerated by utils/aarch64_builtins_test_generator.py
// RUN: %clang_cc1 %s -fsyntax-only -triple aarch64-none-linux-gnu -target-feature +sme -target-feature +sme-f16f16 -target-feature +sve -verify=streaming-guard
// RUN: %clang_cc1 %s -fsyntax-only -triple aarch64-none-linux-gnu -target-feature +sme -target-feature +sme-f8f16 -target-feature +sve -verify=streaming-guard

// REQUIRES: aarch64-registered-target

#include <arm_sme.h>

// Properties: guard="" streaming_guard="sme,(sme-f16f16|sme-f8f16)" flags="streaming-only,requires-za"

void test(void) __arm_inout("za"){
  svfloat16x2_t svfloat16x2_t_val;
  svfloat16x4_t svfloat16x4_t_val;
  uint32_t uint32_t_val;

  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svadd_za16_f16_vg1x2(uint32_t_val, svfloat16x2_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svadd_za16_f16_vg1x4(uint32_t_val, svfloat16x4_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svadd_za16_vg1x2(uint32_t_val, svfloat16x2_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svadd_za16_vg1x4(uint32_t_val, svfloat16x4_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svsub_za16_f16_vg1x2(uint32_t_val, svfloat16x2_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svsub_za16_f16_vg1x4(uint32_t_val, svfloat16x4_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svsub_za16_vg1x2(uint32_t_val, svfloat16x2_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svsub_za16_vg1x4(uint32_t_val, svfloat16x4_t_val);
}

void test_streaming(void) __arm_streaming __arm_inout("za"){
  svfloat16x2_t svfloat16x2_t_val;
  svfloat16x4_t svfloat16x4_t_val;
  uint32_t uint32_t_val;

  svadd_za16_f16_vg1x2(uint32_t_val, svfloat16x2_t_val);
  svadd_za16_f16_vg1x4(uint32_t_val, svfloat16x4_t_val);
  svadd_za16_vg1x2(uint32_t_val, svfloat16x2_t_val);
  svadd_za16_vg1x4(uint32_t_val, svfloat16x4_t_val);
  svsub_za16_f16_vg1x2(uint32_t_val, svfloat16x2_t_val);
  svsub_za16_f16_vg1x4(uint32_t_val, svfloat16x4_t_val);
  svsub_za16_vg1x2(uint32_t_val, svfloat16x2_t_val);
  svsub_za16_vg1x4(uint32_t_val, svfloat16x4_t_val);
}

void test_streaming_compatible(void) __arm_streaming_compatible __arm_inout("za"){
  svfloat16x2_t svfloat16x2_t_val;
  svfloat16x4_t svfloat16x4_t_val;
  uint32_t uint32_t_val;

  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svadd_za16_f16_vg1x2(uint32_t_val, svfloat16x2_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svadd_za16_f16_vg1x4(uint32_t_val, svfloat16x4_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svadd_za16_vg1x2(uint32_t_val, svfloat16x2_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svadd_za16_vg1x4(uint32_t_val, svfloat16x4_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svsub_za16_f16_vg1x2(uint32_t_val, svfloat16x2_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svsub_za16_f16_vg1x4(uint32_t_val, svfloat16x4_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svsub_za16_vg1x2(uint32_t_val, svfloat16x2_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svsub_za16_vg1x4(uint32_t_val, svfloat16x4_t_val);
}
