/*
 * Copyright 2017 Google Inc.
 *
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */

/**************************************************************************************************
 *** This file was autogenerated from GrEllipseEffect.fp; do not modify.
 **************************************************************************************************/
#ifndef GrEllipseEffect_DEFINED
#define GrEllipseEffect_DEFINED
#include "SkTypes.h"
#if SK_SUPPORT_GPU

#include "GrShaderCaps.h"
#include "GrFragmentProcessor.h"
#include "GrCoordTransform.h"
class GrEllipseEffect : public GrFragmentProcessor {
public:
    GrClipEdgeType edgeType() const { return fEdgeType; }
    SkPoint center() const { return fCenter; }
    SkPoint radii() const { return fRadii; }

    static std::unique_ptr<GrFragmentProcessor> Make(GrClipEdgeType edgeType, SkPoint center,
                                                     SkPoint radii, const GrShaderCaps& caps) {
        // Small radii produce bad results on devices without full float.
        if (!caps.floatIs32Bits() && (radii.fX < 0.5f || radii.fY < 0.5f)) {
            return nullptr;
        }
        return std::unique_ptr<GrFragmentProcessor>(new GrEllipseEffect(edgeType, center, radii));
    }
    GrEllipseEffect(const GrEllipseEffect& src);
    std::unique_ptr<GrFragmentProcessor> clone() const override;
    const char* name() const override { return "EllipseEffect"; }

private:
    GrEllipseEffect(GrClipEdgeType edgeType, SkPoint center, SkPoint radii)
            : INHERITED(kGrEllipseEffect_ClassID,
                        (OptimizationFlags)kCompatibleWithCoverageAsAlpha_OptimizationFlag)
            , fEdgeType(edgeType)
            , fCenter(center)
            , fRadii(radii) {}
    GrGLSLFragmentProcessor* onCreateGLSLInstance() const override;
    void onGetGLSLProcessorKey(const GrShaderCaps&, GrProcessorKeyBuilder*) const override;
    bool onIsEqual(const GrFragmentProcessor&) const override;
    GR_DECLARE_FRAGMENT_PROCESSOR_TEST
    GrClipEdgeType fEdgeType;
    SkPoint fCenter;
    SkPoint fRadii;
    typedef GrFragmentProcessor INHERITED;
};
#endif
#endif
