
#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <orc/orc.h>
#include <orc-test/orctest.h>


int error = FALSE;

char * get_desc (OrcStaticOpcode *opcode);
char * get_code (OrcStaticOpcode *opcode);

int
main (int argc, char *argv[])
{
  int i;
  OrcOpcodeSet *opcode_set;

  orc_init();
  orc_test_init();
  
  printf("<!-- generated by %s -->\n\n", __FILE__);
  printf("| Opcode | Dest Size | Src 1 Size | Src 2 Size | Description | Pseudo Code |\n");
  printf("|--------|-----------|------------|------------|-------------|-------------|\n");

  opcode_set = orc_opcode_set_get ("sys");

  for(i=0;i<opcode_set->n_opcodes;i++){
    printf("| %s | %d | %d | ", 
           opcode_set->opcodes[i].name,
           opcode_set->opcodes[i].dest_size[0],
           opcode_set->opcodes[i].src_size[0]);
    
    if (opcode_set->opcodes[i].src_size[1]) {
      printf("%d%s", opcode_set->opcodes[i].src_size[1],
          (opcode_set->opcodes[i].flags & ORC_STATIC_OPCODE_SCALAR) ? "S" : "");
    } else {
      printf(" ");
    }
    
    printf(" | %s | %s |\n", get_desc(&opcode_set->opcodes[i]), get_code(&opcode_set->opcodes[i]));
  }

  return 0;
}

struct a {
  char *name;
  char *code;
  char *desc;
};

struct a ops[] = {
  { "absb", "(a < 0) ? -a : a", "absolute value" },
  { "addb", "a + b", "add" },
  { "addssb", "clamp(a + b)", "add with signed saturate" },
  { "addusb", "clamp(a + b)", "add with unsigned saturate" },
  { "andb", "a & b", "bitwise AND" },
  { "andnb", "a & (~b)", "bitwise AND NOT" },
  { "avgsb", "(a + b + 1)>>1", "signed average" },
  { "avgub", "(a + b + 1)>>1", "unsigned average" },
  { "cmpeqb", "(a == b) ? (~0) : 0", "compare equal" },
  { "cmpgtsb", "(a > b) ? (~0) : 0", "compare greater than" },
  { "copyb", "a", "copy" },
  { "maxsb", "(a > b) ? a : b", "signed maximum" },
  { "maxub", "(a > b) ? a : b", "unsigned maximum" },
  { "minsb", "(a < b) ? a : b", "signed minimum" },
  { "minub", "(a < b) ? a : b", "unsigned minimum" },
  { "mullb", "a * b", "low bits of multiply" },
  { "mulhsb", "(a * b) >> 8", "high bits of signed multiply" },
  { "mulhub", "(a * b) >> 8", "high bits of unsigned multiply" },
  { "orb", "a \\| b", "bitwise or" },
  { "shlb", "a << b", "shift left" },
  { "shrsb", "a >> b", "signed shift right" },
  { "shrub", "a >> b", "unsigned shift right" },
  { "signb", "sign(a)", "sign" },
  { "subb", "a - b", "subtract" },
  { "subssb", "clamp(a - b)", "subtract with signed saturate" },
  { "subusb", "clamp(a - b)", "subtract with unsigned saturate" },
  { "xorb", "a ^ b", "bitwise XOR" },
  { "absw", "(a < 0) ? -a : a", "absolute value" },
  { "addw", "a + b", "add" },
  { "addssw", "clamp(a + b)", "add with signed saturate" },
  { "addusw", "clamp(a + b)", "add with unsigned saturate" },
  { "andw", "a & b", "bitwise AND" },
  { "andnw", "a & (~b)", "bitwise AND NOT" },
  { "avgsw", "(a + b + 1)>>1", "signed average" },
  { "avguw", "(a + b + 1)>>1", "unsigned average" },
  { "cmpeqw", "(a == b) ? (~0) : 0", "compare equal" },
  { "cmpgtsw", "(a > b) ? (~0) : 0", "compare greater than" },
  { "copyw", "a", "copy" },
  { "maxsw", "(a > b) ? a : b", "signed maximum" },
  { "maxuw", "(a > b) ? a : b", "unsigned maximum" },
  { "minsw", "(a < b) ? a : b", "signed minimum" },
  { "minuw", "(a < b) ? a : b", "unsigned minimum" },
  { "mullw", "a * b", "low bits of multiply" },
  { "mulhsw", "(a * b) >> 16", "high bits of signed multiply" },
  { "mulhuw", "(a * b) >> 16", "high bits of unsigned multiply" },
  { "orw", "a \\| b", "bitwise or" },
  { "shlw", "a << b", "shift left" },
  { "shrsw", "a >> b", "signed shift right" },
  { "shruw", "a >> b", "unsigned shift right" },
  { "signw", "sign(a)", "sign" },
  { "subw", "a - b", "subtract" },
  { "subssw", "clamp(a - b)", "subtract with signed saturate" },
  { "subusw", "clamp(a - b)", "subtract with unsigned saturate" },
  { "xorw", "a ^ b", "bitwise XOR" },
  { "absl", "(a < 0) ? -a : a", "absolute value" },
  { "addl", "a + b", "add" },
  { "addssl", "clamp(a + b)", "add with signed saturate" },
  { "addusl", "clamp(a + b)", "add with unsigned saturate" },
  { "andl", "a & b", "bitwise AND" },
  { "andnl", "a & (~b)", "bitwise AND NOT" },
  { "avgsl", "(a + b + 1)>>1", "signed average" },
  { "avgul", "(a + b + 1)>>1", "unsigned average" },
  { "cmpeql", "(a == b) ? (~0) : 0", "compare equal" },
  { "cmpgtsl", "(a > b) ? (~0) : 0", "compare greater than" },
  { "copyl", "a", "copy" },
  { "maxsl", "(a > b) ? a : b", "signed maximum" },
  { "maxul", "(a > b) ? a : b", "unsigned maximum" },
  { "minsl", "(a < b) ? a : b", "signed minimum" },
  { "minul", "(a < b) ? a : b", "unsigned minimum" },
  { "mulll", "a * b", "low bits of multiply" },
  { "mulhsl", "(a * b) >> 32", "high bits of signed multiply" },
  { "mulhul", "(a * b) >> 32", "high bits of unsigned multiply" },
  { "orl", "a \\| b", "bitwise or" },
  { "shll", "a << b", "shift left" },
  { "shrsl", "a >> b", "signed shift right" },
  { "shrul", "a >> b", "unsigned shift right" },
  { "signl", "sign(a)", "sign" },
  { "subl", "a - b", "subtract" },
  { "subssl", "clamp(a - b)", "subtract with signed saturate" },
  { "subusl", "clamp(a - b)", "subtract with unsigned saturate" },
  { "xorl", "a ^ b", "bitwise XOR" },

  { "convsbw", "a", "convert signed to wider" },
  { "convubw", "a", "convert unsigned to wider" },
  { "convswl", "a", "convert signed to wider" },
  { "convuwl", "a", "convert unsigned to wider" },
  { "convslq", "a", "convert signed to wider" },
  { "convulq", "a", "convert unsigned to wider" },
  { "convwb", "a", "convert signed to narrower" },
  { "convlw", "a", "convert signed to narrower" },
  { "convql", "a", "convert signed to narrower" },
  { "convsuswb", "clamp(a)", "convert signed to unsigned with saturation" },
  { "convsuslw", "clamp(a)", "convert signed to unsigned with saturation" },
  { "convsusql", "clamp(a)", "convert signed to unsigned with saturation" },
  { "convuuswb", "clamp(a)", "convert unsigned to unsigned with saturation" },
  { "convuuslw", "clamp(a)", "convert unsigned to unsigned with saturation" },
  { "convuusql", "clamp(a)", "convert unsigned to unsigned with saturation" },
  { "convssswb", "clamp(a)", "convert signed to signed with saturation" },
  { "convssslw", "clamp(a)", "convert signed to signed with saturation" },
  { "convsssql", "clamp(a)", "convert signed to signed with saturation" },
  { "convusswb", "clamp(a)", "convert unsigned to signed with saturation" },
  { "convusslw", "clamp(a)", "convert unsigned to signed with saturation" },
  { "convussql", "clamp(a)", "convert unsigned to signed with saturation" },

  { "mulsbw", "a * b", "multiply signed to wider" },
  { "mulubw", "a * b", "multiply unsigned to wider" },
  { "mulswl", "a * b", "multiply signed to wider" },
  { "muluwl", "a * b", "multiply unsigned to wider" },
  { "mulslq", "a * b", "multiply signed to wider" },
  { "mululq", "a * b", "multiply unsigned to wider" },

  { "mergelq", "special", "merge words" },
  { "mergewl", "special", "merge halfwords" },
  { "mergebw", "special", "merge bytes" },

  { "select0lw", "special", "select first half" },
  { "select0wb", "special", "select first half" },
  { "select1lw", "special", "select second half" },
  { "select1wb", "special", "select second half" },
  { "select0ql", "special", "select first half" },
  { "select1ql", "special", "select second half" },
  { "swapq", "special", "endianness byte swap" },
  { "swapw", "special", "endianness byte swap" },
  { "swapl", "special", "endianness byte swap" },
  { "swapwl", "special", "endianness word swap" },
  { "swaplq", "special", "endianness long word swap" },

  { "accw", "+= a", "accumulate" },
  { "accl", "+= a", "accumulate" },
  { "accsadubl", "+= abs(a - b)", "accumulate absolute difference" },

  { "splitql" , "special", "split first/second long words" },
  { "splitlw" , "special", "split first/second words" },
  { "splitwb" , "special", "split first/second bytes" },

  { "addf", "a + b", "add" },
  { "addd", "a + b", "add" },
  { "subf", "a - b", "subtract" },
  { "subd", "a - b", "subtract" },
  { "mulf", "a * b", "multiply" },
  { "muld", "a * b", "multiply" },
  { "divf", "a / b", "divide" },
  { "divd", "a / b", "divide" },
  { "orf", "a \\| b", "bitwise or"},
  { "andf", "a & b", "bitwise and"},
  { "sqrtf", "sqrt(a)", "square root" },
  { "sqrtd", "sqrt(a)", "square root" },
  { "maxf", "max(a,b)", "maximum" },
  { "maxd", "max(a,b)", "maximum" },
  { "minf", "min(a,b)", "minimum" },
  { "mind", "min(a,b)", "minimum" },
  { "cmpeqf", "(a == b) ? (~0) : 0", "compare equal" },
  { "cmpeqd", "(a == b) ? (~0) : 0", "compare equal" },
  { "cmpltf", "(a == b) ? (~0) : 0", "compare less than" },
  { "cmpltd", "(a == b) ? (~0) : 0", "compare less than" },
  { "cmplef", "(a == b) ? (~0) : 0", "compare less than or equal" },
  { "cmpled", "(a == b) ? (~0) : 0", "compare less than or equal" },
  { "convfl", "a", "convert float point to integer" },
  { "convlf", "a", "convert integer to floating point" },
  { "convdl", "a", "convert double point to integer" },
  { "convld", "a", "convert integer to double point" },
  { "convfd", "a", "convert float to double" },
  { "convdf", "a", "convert double to float" },
  
  { "loadb", "array[i]", "load from memory" },
  { "loadw", "array[i]", "load from memory" },
  { "loadl", "array[i]", "load from memory" },
  { "loadq", "array[i]", "load from memory" },
  { "storeb", "special", "store to memory" },
  { "storew", "special", "store to memory" },
  { "storel", "special", "store to memory" },
  { "storeq", "special", "store to memory" },
  { "loadoffb", "array[i+offset]", "load from memory with offset" },
  { "loadoffw", "array[i+offset]", "load from memory with offset" },
  { "loadoffl", "array[i+offset]", "load from memory with offset" },
  { "loadoffq", "array[i+offset]", "load from memory with offset" },
  { "loadpb", "scalar", "load parameter or constant" },
  { "loadpw", "scalar", "load parameter or constant" },
  { "loadpl", "scalar", "load parameter or constant" },
  { "loadpq", "scalar", "load parameter or constant" },
  { "loadupdb", "array[i>>1]", "load upsampled duplicate" },
  { "loadupib", "(array[i>>1] + array[(i+1)>>1] + 1)>>1",
    "load upsampled interpolate" },
  { "ldresnearb", "array[(b+c*i)>>8]", "load, nearest neighbor resampled" },
  { "ldreslinb", "special", "load, bilinear resampled" },
  { "ldresnearl", "array[(b+c*i)>>8]", "load, nearest neighbor resampled" },
  { "ldreslinl", "special", "load, bilinear resampled" },
  { "div255w", "a/255", "divide by 255" },
  { "divluw", "clamp(a/(b & 255),0,255)", "saturated unsigned divide 16-bit by 8-bit" },
  { "splatw3q", "special", "duplicates high 16-bits to lower 48 bits" },
  { "splatbw", "special", "duplicates 8 bits to both halfs of 16 bits" },
  { "splatbl", "special", "duplicates 8 bits to all parts of 32 bits" },
  { "convql", "a", "convert" },
  { "convslq", "a", "signed convert" },
  { "convulq", "a", "unsigned convert" },
  { "convhwb", "a>>8", "shift and convert" },
  { "convhlw", "a>>16", "shift and convert" },
  { "convsssql", "clamp(a)", "convert signed to signed with saturation" },
  { "convsusql", "clamp(a)", "convert signed to unsigned with saturation" },
  { "convussql", "clamp(a)", "convert unsigned to signed with saturation" },
  { "convuusql", "clamp(a)", "convert unsigned to unsigned with saturation" },

};


char *
get_desc (OrcStaticOpcode *opcode)
{
  int i;
  for(i=0;i<sizeof(ops)/sizeof(ops[0]);i++){
    if (strcmp (opcode->name, ops[i].name) == 0) {
      return ops[i].desc;
    }
  }
  return "";
}

char *
get_code (OrcStaticOpcode *opcode)
{
  int i;
  for(i=0;i<sizeof(ops)/sizeof(ops[0]);i++){
    if (strcmp (opcode->name, ops[i].name) == 0) {
      return ops[i].code;
    }
  }
  return "";
}

