/*
 *             Copyright Andrey Semashev 2018.
 * Distributed under the Boost Software License, Version 1.0.
 *    (See accompanying file LICENSE_1_0.txt or copy at
 *          http://www.boost.org/LICENSE_1_0.txt)
 */
/*!
 * \file   process_abi.cpp
 * \author Andrey Semashev
 * \date   10.03.2018
 *
 * \brief  This file contains ABI test for process.hpp
 */

#include <boost/winapi/process.hpp>
#include <windows.h>
#include <boost/predef/platform/windows_uwp.h>
#include "abi_test_tools.hpp"

int main()
{
#if BOOST_WINAPI_PARTITION_APP_SYSTEM

    BOOST_WINAPI_TEST_CONSTANT(DEBUG_PROCESS);
    BOOST_WINAPI_TEST_CONSTANT(DEBUG_ONLY_THIS_PROCESS);
    BOOST_WINAPI_TEST_CONSTANT(CREATE_SUSPENDED);
    BOOST_WINAPI_TEST_CONSTANT(DETACHED_PROCESS);
    BOOST_WINAPI_TEST_CONSTANT(CREATE_NEW_CONSOLE);
    BOOST_WINAPI_TEST_CONSTANT(CREATE_NEW_PROCESS_GROUP);
    BOOST_WINAPI_TEST_CONSTANT(CREATE_UNICODE_ENVIRONMENT);
    BOOST_WINAPI_TEST_CONSTANT(CREATE_SEPARATE_WOW_VDM);
    BOOST_WINAPI_TEST_CONSTANT(CREATE_SHARED_WOW_VDM);
    BOOST_WINAPI_TEST_CONSTANT(CREATE_FORCEDOS);
    BOOST_WINAPI_TEST_CONSTANT(CREATE_BREAKAWAY_FROM_JOB);
    BOOST_WINAPI_TEST_CONSTANT(CREATE_DEFAULT_ERROR_MODE);
    BOOST_WINAPI_TEST_CONSTANT(CREATE_NO_WINDOW);

    BOOST_WINAPI_TEST_CONSTANT(PROFILE_USER);
    BOOST_WINAPI_TEST_CONSTANT(PROFILE_KERNEL);
    BOOST_WINAPI_TEST_CONSTANT(PROFILE_SERVER);

#if BOOST_USE_WINAPI_VERSION >= BOOST_WINAPI_VERSION_WIN6
    BOOST_WINAPI_TEST_CONSTANT(CREATE_PROTECTED_PROCESS);
    BOOST_WINAPI_TEST_CONSTANT(EXTENDED_STARTUPINFO_PRESENT);
#endif

#if BOOST_USE_WINAPI_VERSION >= BOOST_WINAPI_VERSION_WIN7
    BOOST_WINAPI_TEST_CONSTANT(INHERIT_PARENT_AFFINITY);
#endif

#if defined(UNDER_CE)
    BOOST_WINAPI_TEST_CONSTANT(INHERIT_CALLER_PRIORITY);
#endif

#endif // BOOST_WINAPI_PARTITION_APP_SYSTEM

#if BOOST_WINAPI_PARTITION_DESKTOP

    BOOST_WINAPI_TEST_CONSTANT(STARTF_USESHOWWINDOW);
    BOOST_WINAPI_TEST_CONSTANT(STARTF_USESIZE);
    BOOST_WINAPI_TEST_CONSTANT(STARTF_USEPOSITION);
    BOOST_WINAPI_TEST_CONSTANT(STARTF_USECOUNTCHARS);
    BOOST_WINAPI_TEST_CONSTANT(STARTF_USEFILLATTRIBUTE);
    BOOST_WINAPI_TEST_CONSTANT(STARTF_RUNFULLSCREEN);
    BOOST_WINAPI_TEST_CONSTANT(STARTF_FORCEONFEEDBACK);
    BOOST_WINAPI_TEST_CONSTANT(STARTF_FORCEOFFFEEDBACK);
    BOOST_WINAPI_TEST_CONSTANT(STARTF_USESTDHANDLES);
    BOOST_WINAPI_TEST_CONSTANT(STARTF_USEHOTKEY);

#if BOOST_USE_WINAPI_VERSION >= BOOST_WINAPI_VERSION_WIN7
    BOOST_WINAPI_TEST_CONSTANT(STARTF_TITLEISLINKNAME);
    BOOST_WINAPI_TEST_CONSTANT(STARTF_TITLEISAPPID);
    BOOST_WINAPI_TEST_CONSTANT(STARTF_PREVENTPINNING);
#endif

#endif // BOOST_WINAPI_PARTITION_DESKTOP

    BOOST_WINAPI_TEST_CONSTANT(PROCESS_TERMINATE);
    BOOST_WINAPI_TEST_CONSTANT(PROCESS_CREATE_THREAD);
    BOOST_WINAPI_TEST_CONSTANT(PROCESS_SET_SESSIONID);
    BOOST_WINAPI_TEST_CONSTANT(PROCESS_VM_OPERATION);
    BOOST_WINAPI_TEST_CONSTANT(PROCESS_VM_READ);
    BOOST_WINAPI_TEST_CONSTANT(PROCESS_VM_WRITE);
    BOOST_WINAPI_TEST_CONSTANT(PROCESS_DUP_HANDLE);
    BOOST_WINAPI_TEST_CONSTANT(PROCESS_CREATE_PROCESS);
    BOOST_WINAPI_TEST_CONSTANT(PROCESS_SET_QUOTA);
    BOOST_WINAPI_TEST_CONSTANT(PROCESS_SET_INFORMATION);
    BOOST_WINAPI_TEST_CONSTANT(PROCESS_QUERY_INFORMATION);
    BOOST_WINAPI_TEST_CONSTANT(PROCESS_SUSPEND_RESUME);
    BOOST_WINAPI_TEST_CONSTANT(PROCESS_ALL_ACCESS);

#if BOOST_WINAPI_PARTITION_APP_SYSTEM
#if !defined(BOOST_WINAPI_IS_MINGW)
    BOOST_WINAPI_TEST_CONSTANT(CREATE_PRESERVE_CODE_AUTHZ_LEVEL);
    BOOST_WINAPI_TEST_CONSTANT(CREATE_IGNORE_SYSTEM_DEFAULT);
#endif
#endif // BOOST_WINAPI_PARTITION_APP_SYSTEM

#if BOOST_WINAPI_PARTITION_APP_SYSTEM
    BOOST_WINAPI_TEST_STRUCT(PROCESS_INFORMATION, (hProcess)(hThread)(dwProcessId)(dwThreadId));

#if !defined(BOOST_NO_ANSI_APIS)
    BOOST_WINAPI_TEST_STRUCT(STARTUPINFOA, (cb)(lpDesktop)(lpTitle)(dwX)(dwY)(dwXSize)(dwYSize)(dwXCountChars)(dwYCountChars)(dwFillAttribute)(dwFlags)(wShowWindow)(hStdInput)(hStdOutput)(hStdError));
#endif // !defined(BOOST_NO_ANSI_APIS)
    BOOST_WINAPI_TEST_STRUCT(STARTUPINFOW, (cb)(lpDesktop)(lpTitle)(dwX)(dwY)(dwXSize)(dwYSize)(dwXCountChars)(dwYCountChars)(dwFillAttribute)(dwFlags)(wShowWindow)(hStdInput)(hStdOutput)(hStdError));
#endif // BOOST_WINAPI_PARTITION_APP_SYSTEM

#if BOOST_USE_WINAPI_VERSION >= BOOST_WINAPI_VERSION_WIN6
#if BOOST_WINAPI_PARTITION_DESKTOP
#if !defined(BOOST_NO_ANSI_APIS)
    BOOST_WINAPI_TEST_STRUCT(STARTUPINFOEXA, (StartupInfo)(lpAttributeList));
#endif // !defined(BOOST_NO_ANSI_APIS)
    BOOST_WINAPI_TEST_STRUCT(STARTUPINFOEXW, (StartupInfo)(lpAttributeList));
#endif // BOOST_WINAPI_PARTITION_DESKTOP
#endif // BOOST_USE_WINAPI_VERSION >= BOOST_WINAPI_VERSION_WIN6

#if BOOST_WINAPI_PARTITION_APP_SYSTEM
    BOOST_WINAPI_TEST_FUNCTION_SIGNATURE(TerminateProcess);
    BOOST_WINAPI_TEST_FUNCTION_SIGNATURE(OpenProcess);
#endif // BOOST_WINAPI_PARTITION_APP_SYSTEM

#if BOOST_WINAPI_PARTITION_DESKTOP_SYSTEM
    BOOST_WINAPI_TEST_FUNCTION_SIGNATURE(GetExitCodeProcess);
    BOOST_WINAPI_TEST_FUNCTION_SIGNATURE(ExitProcess);
#endif // BOOST_WINAPI_PARTITION_DESKTOP_SYSTEM

    return boost::report_errors();
}
