#! /bin/sh
# check script for Lziprecover - Data recovery tool for lzipped files
# Copyright (C) 2009, 2010, 2011, 2012, 2013 Antonio Diaz Diaz.
#
# This script is free software: you have unlimited permission
# to copy, distribute and modify it.

LC_ALL=C
export LC_ALL
objdir=`pwd`
testdir=`cd "$1" ; pwd`
LZIP="${objdir}"/lziprecover
LZIPRECOVER="${objdir}"/lziprecover
framework_failure() { echo "failure in testing framework" ; exit 1 ; }

if [ ! -x "${LZIP}" ] ; then
	echo "${LZIP}: cannot execute"
	exit 1
fi

if [ -d tmp ] ; then rm -rf tmp ; fi
mkdir tmp
cd "${objdir}"/tmp

in="${testdir}"/test.txt
in_lz="${testdir}"/test_v1.lz
inD="${testdir}"/test921-1921.txt
fox5="${testdir}"/fox5_bad.txt
fox5_lz="${testdir}"/fox5_bad.lz
bad1_lz="${testdir}"/test_bad1.lz
bad2_lz="${testdir}"/test_bad2.lz
bad3_lz="${testdir}"/test_bad3.lz
bad4_lz="${testdir}"/test_bad4.lz
bad5_lz="${testdir}"/test_bad5.lz
fail=0

# Description of test files for lziprecover:
# fox5_bad.lz: byte at offset 188 changed from 0x34 to 0x33
# test_bad1.lz: byte at offset 67 changed from 0xCC to 0x33
# test_bad2.lz: [  34-  66) --> copy of bytes [  68- 100)
# test_bad3.lz: [ 512-1536) --> zeroed;       [2560-3584) --> zeroed
# test_bad4.lz: [3072-4096) --> random data;  [4608-5632) --> zeroed
# test_bad5.lz: [1024-2048) --> random data;  [5120-6144) --> random data

printf "testing lziprecover-%s..." "$2"

"${LZIPRECOVER}" -lq
if [ $? != 1 ] ; then fail=1 ; printf - ; else printf . ; fi
"${LZIPRECOVER}" -mq "${bad1_lz}"
if [ $? != 1 ] ; then fail=1 ; printf - ; else printf . ; fi
"${LZIPRECOVER}" -Rq
if [ $? != 1 ] ; then fail=1 ; printf - ; else printf . ; fi
"${LZIPRECOVER}" -sq
if [ $? != 1 ] ; then fail=1 ; printf - ; else printf . ; fi

"${LZIP}" -t "${testdir}"/test_v0.lz || fail=1
printf .
"${LZIP}" -cd "${testdir}"/test_v0.lz > copy || fail=1
cmp "${in}" copy || fail=1
printf .

"${LZIP}" -t "${testdir}"/test_v1.lz || fail=1
printf .
"${LZIP}" -cd "${testdir}"/test_v1.lz > copy || fail=1
cmp "${in}" copy || fail=1
printf .

"${LZIPRECOVER}" -D 921-1921 -fo copy "${in_lz}" || fail=1
cmp "${inD}" copy || fail=1
printf .
"${LZIPRECOVER}" -D 921,1000 "${in_lz}" > copy || fail=1
cmp "${inD}" copy || fail=1
printf .
"${LZIPRECOVER}" -D0 -iq -fo copy "${fox5_lz}"
if [ $? = 2 ] && cmp "${fox5}" copy ; then printf . ; else fail=1 ; printf - ; fi
"${LZIPRECOVER}" -D0 -iq "${fox5_lz}" > copy
if [ $? = 2 ] && cmp "${fox5}" copy ; then printf . ; else fail=1 ; printf - ; fi

"${LZIPRECOVER}" -m -o copy.lz "${bad1_lz}" "${bad2_lz}" "${bad1_lz}" -q
if [ $? != 2 ] ; then fail=1 ; printf - ; else printf . ; fi
"${LZIPRECOVER}" -m -o copy.lz "${bad1_lz}" "${bad2_lz}" || fail=1
"${LZIPRECOVER}" -df copy.lz || fail=1
cmp "${in}" copy || fail=1
printf .
"${LZIPRECOVER}" -m -o copy.lz "${bad2_lz}" "${bad1_lz}" || fail=1
"${LZIPRECOVER}" -df copy.lz || fail=1
cmp "${in}" copy || fail=1
printf .

for i in "${bad1_lz}" "${bad2_lz}" ; do
	for j in "${bad3_lz}" "${bad4_lz}" "${bad5_lz}" ; do
		"${LZIPRECOVER}" -m -o copy.lz "${i}" "${j}" || fail=1
		"${LZIPRECOVER}" -df copy.lz || fail=1
		cmp "${in}" copy || fail=1
		printf .
		"${LZIPRECOVER}" -m -o copy.lz "${j}" "${i}" || fail=1
		"${LZIPRECOVER}" -df copy.lz || fail=1
		cmp "${in}" copy || fail=1
		printf .
	done
done

"${LZIPRECOVER}" -m -o copy.lz "${bad3_lz}" "${bad4_lz}" "${bad5_lz}" || fail=1
"${LZIPRECOVER}" -df copy.lz || fail=1
cmp "${in}" copy || fail=1
printf .
"${LZIPRECOVER}" -m -o copy.lz "${bad4_lz}" "${bad5_lz}" "${bad3_lz}" || fail=1
"${LZIPRECOVER}" -df copy.lz || fail=1
cmp "${in}" copy || fail=1
printf .
"${LZIPRECOVER}" -m -o copy.lz "${bad5_lz}" "${bad3_lz}" "${bad4_lz}" || fail=1
"${LZIPRECOVER}" -df copy.lz || fail=1
cmp "${in}" copy || fail=1
printf .

"${LZIPRECOVER}" -R "${in_lz}" || fail=1
printf .
"${LZIPRECOVER}" -R -o copy.lz "${bad2_lz}" -q
if [ $? != 2 ] ; then fail=1 ; printf - ; else printf . ; fi
"${LZIPRECOVER}" -R -o copy.lz "${bad1_lz}" || fail=1
"${LZIPRECOVER}" -df copy.lz || fail=1
cmp "${in}" copy || fail=1
printf .

cat "${in_lz}" "${in_lz}" "${in_lz}" > copy || framework_failure
printf "garbage" >> copy || fail=1
"${LZIPRECOVER}" -s -o copy.lz copy || fail=1
for i in 1 2 3 ; do
	"${LZIPRECOVER}" -cd rec${i}copy.lz > copy || fail=1
	cmp "${in}" copy || fail=1
	printf .
done

cat "${in_lz}" > anyothername || framework_failure
"${LZIP}" -d anyothername || fail=1
cmp "${in}" anyothername.out || fail=1
printf .

cat "${in}" "${in}" > in2 || framework_failure
cat "${in_lz}" "${in_lz}" > out2 || framework_failure
"${LZIP}" -d < out2 > copy2 || fail=1
cmp in2 copy2 || fail=1
printf .

echo
if [ ${fail} = 0 ] ; then
	echo "tests completed successfully."
	cd "${objdir}" && rm -r tmp
else
	echo "tests failed."
fi
exit ${fail}
