/*
 * Copyright (C) 2002-4 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif


#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include <errno.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "glade_support.h"

#include "constants.h"
#include "types.h"

#include "new_win.h"

#include "entry.h"
#include "input.h"
#include "misc.h"
#include "run.h"
#include "treeview.h"


static void new_win(void)
{
    show_input(NEW_WIN_INPUT);
    return;
}

/* callbacks */


G_MODULE_EXPORT
void sb_new_win(GtkWidget *w)
{
    new_win();
}

G_MODULE_EXPORT
void sb_new_smb(GtkWidget *w)
{
    gchar *argv[]={"xfsamba4",NULL};
    runv(argv);
    return;
}

G_MODULE_EXPORT
void sb_new_fstab(GtkWidget *w)
{
    gchar *argv[]={"xffstab",NULL};
    runv(argv);
    return;
}

G_MODULE_EXPORT
void sb_new_book(GtkWidget *w)
{
    show_input(NEW_BOOK_WIN_INPUT);
    return;
}

G_MODULE_EXPORT
void sb_new_trash(GtkWidget *w)
{
    gchar *argv[]={"xftrash4",NULL};
    runv(argv);
    return;
}

G_MODULE_EXPORT
void sb_new_recent(GtkWidget *w)
{
    gchar *argv[]={"xfrecent",NULL};
    runv(argv);
    return;
}

G_MODULE_EXPORT
void sb_new_frequent(GtkWidget *w)
{
    gchar *argv[]={"xffrequent",NULL};
    runv(argv);
    return;
}
G_MODULE_EXPORT
void on_new_tree_view2_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    new_win();
}

G_MODULE_EXPORT
void on_new_win(GtkMenuItem * menuitem, gpointer user_data)
{
    sb_new_win((GtkWidget *)menuitem);
}
G_MODULE_EXPORT
void on_new_smb(GtkMenuItem * menuitem, gpointer user_data)
{
    sb_new_smb((GtkWidget *)menuitem);
}
G_MODULE_EXPORT
void on_new_fstab(GtkMenuItem * menuitem, gpointer user_data)
{
    sb_new_fstab((GtkWidget *)menuitem);
}
G_MODULE_EXPORT
void on_new_book(GtkMenuItem * menuitem, gpointer user_data)
{
    sb_new_book((GtkWidget *)menuitem);
}
G_MODULE_EXPORT
void on_new_trash(GtkMenuItem * menuitem, gpointer user_data)
{
    sb_new_trash((GtkWidget *)menuitem);
}
G_MODULE_EXPORT
void on_new_recent(GtkMenuItem * menuitem, gpointer user_data)
{
    sb_new_recent((GtkWidget *)menuitem);
}
G_MODULE_EXPORT
void on_new_frequent(GtkMenuItem * menuitem, gpointer user_data)
{
    sb_new_frequent((GtkWidget *)menuitem);
}

G_MODULE_EXPORT
void on_open_in_xffm_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    new_win();
}
