/* basic_row_c */
/*
 * Copyright (C) 2002-4 Edscott Wilson Garcia
 * EMail: edscott@xfce.org
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif
#include <sys/stat.h>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <grp.h>
#include <pwd.h>
#include <errno.h>
#include <regex.h>
#include <dirent.h>
#include <gtk/gtk.h>


#include "constants.h"
#include "types.h"
#include "glade_support.h"

#include "basic_row.h" /* for prototypes */

#include "icons.h" /* for icon_tell(), set_icon()  */
#include "misc.h" /* for set_progress() or process_pending_gtk()*/

#ifdef  USE_FILTER_BAR
# include "filter.h" /* for get_filter() */
#endif

#include "entry.h" /* for make_entry() */

/* static functions: */
#include "basic_local.i"



/*******************************************************************/
/*        adding a local folder 
 *
 *        basic_local.c
 *
 *        ****************************/
/*******************************************************************/


G_MODULE_EXPORT
void 
open_folder_local(	GtkTreeView *treeview,
			GtkTreeIter *iter,
		       	GtkTreePath *treepath,
			tree_entry_t *en)
{
#ifdef USE_FILTER_BAR
    const gchar *filter;
#endif
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    if (!en || !iter || !treeview) return;
    /*printf("DBG:opening %s\n",en->path); */
    
    if (IS_LOADED(en->type) && ! IS_INCOMPLETE(en->type)) return;
    
#ifdef USE_FILTER_BAR
    /* if filterchanged reload as well */
    if ((filter=get_filter(tree_details->window))==NULL) assert_not_reached();
    if (!en->filter) assert_not_reached();
    
    if (IS_LOADED(en->type) && strcmp(en->filter, filter) == 0) return;
	    
    /*printf("DBG: loaded=%d, filter=%s,en->filter=%s\n",
			    IS_LOADED(en->type),
			    (filter)?filter:"NULL",
			    (en->filter)?en->filter:"NULL");*/
#else 
    if (IS_LOADED(en->type)) return;
#endif
    prune_row(treemodel, iter, NULL, en);

    if(IS_ROOT_TYPE(en->type)) {
	insert_dummy_row(treemodel, iter,NULL,en,"xfce/go-up","..");
    } 
    else insert_dummy_row(treemodel, iter,NULL,en,NULL,NULL);
	    
    UNSET_INCOMPLETE(en->type);
    if(access(en->path, X_OK)) return;

    add_folder_local(treeview, iter, en);
    en->count = all_files_count();
    if(IS_ROOT_TYPE(en->type) && en->path && strcmp(en->path,"/")==0) {
	erase_dummy_row(treemodel, iter,NULL);
    }  

    update_text_cell_for_row(SIZE_COLUMN,treemodel, iter,sizetag((off_t)-1, en->count)); 

    hide_stop();

}


