/*
 * Copyright (C) 2002-2004 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>

#include <dirent.h>
#include <errno.h>
#include <limits.h>
#include <memory.h>
#include <regex.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include <glob.h>
#include <dbh.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>


#include "glade_support.h"

#include "constants.h"
#include "types.h"

#include "basic_row.h"

#include "bookmarks.h"

#include "dnd.h"
#include "entry.h"

#ifdef USE_FILTER_BAR
#include "filter.h"
#endif

#include "misc.h"
#include "refresh.h"
#include "widgets.h"
#include "input.h"

/*#define DEBUG*/

extern gchar *bookfile;
extern root_t root[];

static DBHashTable *bookmarks = NULL;
static DBHashTable *newbookmarks = NULL;
static GtkTreeIter *target_iter;
static GtkTreeView *target_treeview;
static int bookmarks_count;
static unsigned int smallcount, countbyte;
static int target_type;

#ifdef USE_FILTER_BAR
static const regex_t *target_preg;
#endif

static xfdir_t bm_xfdir;

static GList *d_list = NULL;
static int check_dir(char *path);

G_MODULE_EXPORT
void set_book_combo (void)
{
    GList *tmp,*new_list = NULL;
    /*GtkEntry *entry;*/
    GtkWidget *w = WIDGET("input_combo");
	gchar *xdg_dir=xfce_resource_save_location (XFCE_RESOURCE_CACHE,"/",TRUE);
	glob_t dirlist;
	int i;
	gchar *globstring,*p;

#if 0
	globstring = g_strconcat(bm_dir,"/*.bm.dbh",NULL);
#endif
	p = g_build_filename(xdg_dir,BOOKMARK_DIR,NULL);
	g_free(xdg_dir);
	globstring = g_strconcat(p,G_DIR_SEPARATOR_S,"*.bm.dbh",NULL);
	g_free(p);
	
	if (glob (globstring, GLOB_ERR, NULL, &dirlist) != 0) {
		return;
	} else {
	   for (i = 0; i < dirlist.gl_pathc; i++){
	      gchar *p,*g=g_path_get_basename(dirlist.gl_pathv[i]);
	      if(!strstr(g,".bm.dbh")) continue;
	      p=strstr(g,".bm.dbh");
	      *p=0;
	      new_list = g_list_append(new_list, g);
	   }
	}
  	globfree (&dirlist);

    
    gtk_combo_set_popdown_strings(GTK_COMBO(w), new_list);
    for (tmp=new_list;tmp;tmp=tmp->next){
	    gchar *g=(gchar *)tmp->data;
	    g_free(g);
	    g=NULL;
    }
    g_list_free(new_list);
}

G_MODULE_EXPORT
void reload_book (GtkTreeView *treeview){
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    GtkTreeSelection *selection = gtk_tree_view_get_selection(treeview);
    GtkTreePath *treepath;
    tree_entry_t *en;
    GtkTreeIter iter;
    get_bookmark_root(treeview,&iter, &en);
    clear_dnd_selection_list();
    treepath = gtk_tree_model_get_path(treemodel, &iter);
    gtk_tree_selection_select_path (selection,treepath);
    gtk_tree_view_set_cursor (treeview,treepath,NULL,FALSE);
    gtk_tree_path_free(treepath);

    update_text_cell_for_row(NAME_COLUMN,treemodel, &iter,(bookfile)?
	    g_strdup(my_utf_string(bookfile)):
	    g_strdup(my_utf_string(_(root[ROOT_BOOKMARKS].label)))
	    );
    on_refresh((GtkButton *) treeview,NULL);
}


G_MODULE_EXPORT
char *get_bookfile_path (void){
    gchar *bookmarks_dir;
    static gchar *bookmarks_path=NULL;
    gchar *xdg_dir=xfce_resource_save_location (XFCE_RESOURCE_CACHE,"/",TRUE);

    bookmarks_dir = g_build_filename(xdg_dir,BOOKMARK_DIR,NULL);    
    g_free(xdg_dir);
    if(!check_dir(bookmarks_dir)) {
	    g_free(bookmarks_dir);
	    return NULL;
    }
    if (bookmarks_path)  g_free(bookmarks_path);
    
    if (bookfile) {
	    bookmarks_path=g_strconcat(bookmarks_dir,G_DIR_SEPARATOR_S,bookfile,".bm.dbh",NULL);
    } else {
	    bookmarks_path=g_strconcat(bookmarks_dir,G_DIR_SEPARATOR_S,"bookmarks.dbh",NULL);
    }
    g_free(bookmarks_dir);
#ifdef DEBUG
    printf("DBG: using %s\n",bookmarks_path);
#endif
    return bookmarks_path;
}


static void bookmarks_dlist(DBHashTable * dbh)
{
    char *fullpath = (char *)DBH_DATA(dbh);
    struct stat st;
    stat(fullpath, &st);
    if(S_ISDIR(st.st_mode))
    {
	d_list = g_list_append(d_list, g_strdup(fullpath));
    }
}


G_MODULE_EXPORT
GList *get_bookmark_dirlist (void)
{
    char *bookmarks_path=get_bookfile_path();
    d_list = NULL;

    if (!bookmarks_path) return NULL;
    chmod(bookmarks_path,S_IRUSR|S_IWUSR);
    if((bookmarks = DBH_open(bookmarks_path)) == NULL)
	return NULL;
    DBH_foreach_sweep(bookmarks, bookmarks_dlist);
    DBH_close(bookmarks);
    return d_list;
}


static int check_dir(char *path)
{
    struct stat st;
    if(stat(path, &st) < 0)
    {
	if(mkdir(path, 0770) < 0)
	    return FALSE;
	return TRUE;
    }
    if(S_ISDIR(st.st_mode))
    {
	if(access(path, W_OK) < 0)
	    return FALSE;
	return TRUE;
    }
    return FALSE;
}

static void add2treeview(GtkTreeView * treeview, char *path)
{
    char *name = path;
    GtkTreePath *treepath;
    GtkTreeIter target;
    gboolean is_net_stuff=FALSE;
    tree_entry_t *en;
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    if (strncmp(path,"smb://",strlen("smb://"))==0 ||
	strncmp(path,"SMB://",strlen("SMB://"))==0    ) {
	    is_net_stuff=TRUE;
	    name=strchr(path,'@')+1;
    } else if(strlen(path) > 1)
    {
	name = strrchr(path, '/');
	if(!name)
	    assert_not_reached();
	name++;
    }
    get_bookmark_root(treeview, &target, &en);
#ifdef DEBUG
    printf("DBG:add2treeview(%s)\n",(en->path)?en->path:"null");
#endif
    /*if(!IS_EXPANDED(en->type))return;*/
    if (!IS_LOADED(en->type)) SET_LOADED(en->type);
    
    if (is_net_stuff){
          en=mk_net_entry(path,en->type);
    }
    else en = stat_entry(path, en->type);
    add_row(treemodel, &target, NULL, NULL,  en, name);
    erase_dummy_row(treemodel, &target,NULL);

    /* expand + scroll to */
    treepath = gtk_tree_model_get_path(treemodel, &target);
    gtk_tree_view_expand_row(treeview, treepath, FALSE);
    gdk_flush();
    gtk_tree_view_scroll_to_cell(treeview, treepath, NULL, TRUE, 0.0, 0.0);
    gtk_tree_path_free(treepath);
    /*SET_LOADED(en->type); bug? */

    return;
}

G_MODULE_EXPORT
int add2bookmarks (GtkTreeView * treeview, char *path)
{
    char *bm=get_bookfile_path();
    struct stat st;
    GString *gs;
    tree_entry_t *en;
    GtkTreeIter target;
    GtkTreePath *treepath;
    gboolean is_net_stuff=FALSE;
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    gchar *d_path=NULL;
    gchar *message=NULL;

    if (strncmp(path,"smb://",strlen("smb://"))==0||
	strncmp(path,"SMB://",strlen("SMB://"))==0) {
	    is_net_stuff=TRUE;
    }
    else {
	    if (lstat(path, &st) < 0) return -1;
    }

    get_bookmark_root(treeview, &target, &en);
    treepath = gtk_tree_model_get_path(treemodel, &target);
    gtk_tree_view_expand_row(treeview, treepath, FALSE);
    gtk_tree_path_free(treepath);

    process_pending_gtk();

    /* keep file protected. */
    chmod(bm,S_IRUSR|S_IWUSR);
    if((bookmarks = DBH_open(bm)) == NULL)
    {
	if((bookmarks = DBH_create(bm, 11)) == NULL)
	    return -1;
    }

    if (is_net_stuff)
    {
	gchar *g;
	d_path=g_strconcat("//",strchr(path,'@')+1,NULL);
	if (d_path[strlen(d_path)-1]==':') *(strrchr(d_path,':'))=0;
	for (g=d_path;*g;g++) if (*g==':'){*g='/'; break;}
    }
    else d_path=g_strdup(path);
    
    gs = g_string_new(d_path);
    sprintf((char *)DBH_KEY(bookmarks), "%10u", g_string_hash(gs));
    g_string_free(gs, TRUE);
    /*printf("DBG: bookmarking with key=%s\n",d_path);*/
    
    if(!DBH_load(bookmarks))
    {
	memcpy(DBH_DATA(bookmarks), (void *)path, strlen(path) + 1);
	DBH_set_recordsize(bookmarks, strlen(path) + 1);
	if(!DBH_update(bookmarks))
	{
	    const gchar *fmt=N_("\%s NOT booked (\%s)");
	    message=g_strdup_printf(fmt,d_path,DBH_KEY(bookmarks));
	    print_diagnostics("xfce/error", message, "\n", NULL);
	    g_free(message);
	}
	else
	{
	    const gchar *fmt=N_("\%s booked");
	    add2treeview(treeview, path);
	    message=g_strdup_printf(fmt,d_path);
	    print_diagnostics("xfce/error", message, "\n", NULL);
	    g_free(message);
	    if(d_path && strlen(d_path) >= 2){
		message=g_strdup_printf(fmt,abreviate(d_path));
		print_status("xfce/info",message, NULL);
		g_free(message);
	    }
	}
	DBH_close(bookmarks);
	unset_load_wait();
	g_free(d_path);
	d_path=NULL;
	return TRUE;
    }
    message=g_strdup_printf(_("\%s already in book"),path);
    print_diagnostics("xfce/warning",message, "\n", NULL);
    g_free(message);
    DBH_close(bookmarks);
    g_free(d_path);
    d_path=NULL;
    return FALSE;
}


static void count_bookmarks(DBHashTable * dbh)
{
    bookmarks_count++;
    return;
}

static void add_bookmarks(DBHashTable * dbh)
{
    char *p;
    struct stat st;
    char *fullpath = (char *)DBH_DATA(dbh);

    if (strncmp(fullpath,"smb://",strlen("smb://"))==0||
	strncmp(fullpath,"SMB://",strlen("SMB://"))==0	    )
    	    p = strrchr(fullpath, '@');
    else
	    p = strrchr(fullpath, '/');

    /*printf("DBG:%s -> %s\n",fullpath,p); */
    if(!p || strlen(p) <= 1) return;
    p++;
    

    if(stat(fullpath, &st) >= 0){
    	bm_xfdir.gl[bm_xfdir.pathc].en = stat_entry(fullpath, target_type);
    } 
    else if (strncmp(fullpath,"smb://",strlen("smb://"))==0||
	strncmp(fullpath,"SMB://",strlen("SMB://"))==0){
          bm_xfdir.gl[bm_xfdir.pathc].en=mk_net_entry(fullpath,target_type);
    } else return;
    if(!bm_xfdir.gl[bm_xfdir.pathc].en) assert_not_reached();
    
    SET_TOP_BOOKMARK(bm_xfdir.gl[bm_xfdir.pathc].en->subtype);
         
    bm_xfdir.gl[bm_xfdir.pathc].pathv = g_strdup(p);
    bm_xfdir.pathc++;
    return;
}


G_MODULE_EXPORT
int open_bookmarks (GtkTreeView * treeview, GtkTreeIter * iter, GtkTreePath * treepath, gpointer user_data)
{
    char *bookmarks_path=get_bookfile_path();
    tree_entry_t *en;
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    if (!bookmarks_path) return -1;

    gtk_tree_model_get(treemodel, iter, ENTRY_COLUMN, &en, -1);
    if (!en) return -1;   
    target_iter = iter;
    target_treeview = treeview;
    target_type = en->type;
 
    smallcount = 0, countbyte = 0x10;	/* for dummy tag */
    bookmarks_count = 0;	/* for count step */
    bm_xfdir.pathc = 0;		/* for read step */
    chmod(bookmarks_path,S_IRUSR|S_IWUSR);
    if((bookmarks = DBH_open(bookmarks_path)) == NULL)
	return -1;
    /*printf("DBG:opening book\n"); */
    
    cursor_wait();

#ifdef USE_FILTER_BAR
/* returns compiled regex and sets filter in tree_entry */
    if (!en) target_preg = NULL;
    else target_preg = compile_regex_filter(en->filter,SHOWS_HIDDEN(en->type));
    /*target_preg = get_regex_filter(en);*/
#endif

    /*printf("DBG:counting book elements\n"); */

    DBH_foreach_sweep(bookmarks, count_bookmarks);
    /*printf("DBG:pathc=%d\n",bm_xfdir.pathc); */

    if(DBH_ERASED_SPACE(bookmarks))
    {
	/*printf("DBG: erased space=%d\n",DBH_ERASED_SPACE(bookmarks)); */
	SET_ERASED_SPACE(en->type);
    }
    else
	UNSET_ERASED_SPACE(en->type);
    if(bookmarks_count)
    {
	bm_xfdir.gl = (dir_t *) malloc(bookmarks_count * sizeof(dir_t));
	if(!bm_xfdir.gl)
	    assert_not_reached();
	DBH_foreach_sweep(bookmarks, add_bookmarks);
	/*printf("DBG:count=%d\n",bookmarks_count); */
	if(bookmarks_count != bm_xfdir.pathc)
	{
	    SET_ERASED_SPACE(en->type);
	}
	add_contents_row(treemodel, iter, &bm_xfdir);
	xfdirfree(&bm_xfdir);
    }
    else
    {
	SET_LOADED(en->type);
	reset_dummy_row(treemodel, iter,NULL,en,"xfce/warning",_("Loading..."));
    }
    DBH_close(bookmarks);

    if(tree_details->stop)
    {
	tree_details->stop = FALSE;
	/*sprintf(en->tag, "%s : %s", FILENAME(en),strerror(ETIMEDOUT));*/
	en->tag=g_strconcat(FILENAME(en)," : ",strerror(ETIMEDOUT),NULL);
    }
    else
    {
	hide_stop();
	/*sprintf(en->tag, "%s : %d %s", _("Book"), bm_xfdir.pathc, _("items"));*/
	en->tag=g_strdup_printf ("%s : %d %s", _("Book"), bm_xfdir.pathc, _("items"));	
	if (!bm_xfdir.pathc){
	   /*char *bp=get_bookfile_path();*/
	   reset_dummy_row(treemodel, iter,NULL,en,"xfce/info", _("Use drag+drop to add"));
	   /* do an automatic purge:  NO!!!*/
	   /*unlink(bp);*/
	}
	else erase_dummy_row(treemodel, iter,NULL);
	
    }

    cursor_reset();

    return 0;
}

/* This is basically a DBH_regen(), except that temporary file is
 * within the scope of xffm, not dbh */

G_MODULE_EXPORT
void purge_bookmarks (DBHashTable * dbh)
{
    struct stat st;
    char *p;
    char *fullpath = (char *)DBH_DATA(dbh);

    if(!newbookmarks)
	assert_not_reached();
    p = strrchr(fullpath, '/');
    if(p)
    {
	p++;
	if(stat(fullpath, &st) < 0)
	    return;
    }
    /* copy the key from the old record to the new record */
    memcpy(DBH_KEY(newbookmarks), DBH_KEY(bookmarks), DBH_KEYLENGTH(bookmarks));
    /* copy the data from the old record to the new record */
    memcpy(newbookmarks->data, bookmarks->data, DBH_RECORD_SIZE(bookmarks));
    /* I always forget this instruction, and it is the most important
     * (since DBH records have a variable size): */
    DBH_set_recordsize(newbookmarks, DBH_RECORD_SIZE(bookmarks));
    /* write the record to the new file; */
    if(!DBH_update(newbookmarks))
	assert_not_reached();
    /*printf("DBG:clean record: %s\n",fullpath); */
    return;
}



/****  callbacks *********/


G_MODULE_EXPORT
void on_clear_all_bookmarks_activate (GtkMenuItem * menuitem, gpointer user_data)
{
    char *bm=get_bookfile_path();
    GtkTreeIter parent;
    tree_entry_t *en;
    gint tree_id = get_active_tree_id();
    GtkTreeView *treeview = tree_details->treestuff[tree_id].treeview;
    GtkTreeModel *treemodel = tree_details->treestuff[tree_id].treemodel;

    get_bookmark_root(treeview, &parent, &en);
    prune_row(treemodel, &parent, NULL, en);
    insert_dummy_row(treemodel, &parent, NULL, en,"xfce/info",_("Use drag+drop to add"));
    
    
    unlink(bm);
    UNSET_ERASED_SPACE(en->type);

}




G_MODULE_EXPORT
void on_purge_bookmarks1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
    gint tree_id = get_active_tree_id();
    GtkTreeView *treeview = tree_details->treestuff[tree_id].treeview;
    GtkTreeIter iter;
    tree_entry_t *en;
    gchar *fname;
    char *bookmarks_path=get_bookfile_path();

    if (!bookmarks_path) return;
    {
	gchar *xdg_dir=xfce_resource_save_location (XFCE_RESOURCE_CACHE,"/",TRUE);
	fname = g_build_filename(xdg_dir,BOOKMARK_DIR,NULL);
	g_free(xdg_dir);
    }
    chdir(fname);
    g_free(fname);
    fname = g_strdup("bookmarks.XXXXXX");
    /*strcpy(fname, "bookmarks.XXXXXX");*/
    close(mkstemp(fname));

    chmod(bookmarks_path,S_IRUSR|S_IWUSR);
    bookmarks = DBH_open(bookmarks_path);
    newbookmarks = DBH_create(fname, DBH_KEYLENGTH(bookmarks));
    DBH_foreach_sweep(bookmarks, purge_bookmarks);
    DBH_close(bookmarks);
    DBH_close(newbookmarks);
    rename(fname, bookmarks_path);
    get_bookmark_root(treeview, &iter, &en);
    UNSET_ERASED_SPACE(en->type);
    on_refresh((GtkButton *) tree_details->window, NULL);
    chdir(GETWD);
    g_free(fname);
}

G_MODULE_EXPORT
void on_remove_from_bookmarks_activate (GtkMenuItem * menuitem, gpointer user_data)
{
    char *bm=get_bookfile_path();
    GtkTreeIter iter, parent;
    tree_entry_t *en;
    gint tree_id = get_active_tree_id();
    GtkTreeView *treeview = tree_details->treestuff[tree_id].treeview;
    GtkTreeModel *treemodel = tree_details->treestuff[tree_id].treemodel;
    GtkTreeSelection *selection = tree_details->treestuff[tree_id].selection;

    /*get selection */
    en = get_selected_entry( &iter);
    if(!en)
	assert_not_reached();

    chmod(bm,S_IRUSR|S_IWUSR);
    if((bookmarks = DBH_open(bm)) != NULL)
    {
	GString *gs;
	gs = g_string_new(en->path);
	/*printf("DBG: get stringhash =%10u\n", g_string_hash(gs));*/
	sprintf((char *)DBH_KEY(bookmarks), "%10u", g_string_hash(gs));
	g_string_free(gs, TRUE);
	if (!DBH_erase(bookmarks)){
		printf("DBG: cannot erase %s\n",en->path);
	}
	DBH_close(bookmarks);
    }
    gtk_tree_selection_set_mode(selection, GTK_SELECTION_BROWSE);
    if(gtk_tree_selection_get_selected(selection, &treemodel, &iter))
    {
	remove_row(treemodel, &iter,NULL,NULL);
    }
    gtk_tree_selection_set_mode(selection, GTK_SELECTION_MULTIPLE);
    get_bookmark_root(treeview, &parent, &en);
    insert_dummy_row(treemodel, &parent,NULL,en,"xfce/info",_("Use drag+drop to add"));
    SET_ERASED_SPACE(en->type);
}


G_MODULE_EXPORT
void
on_save_book                           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    show_input(SAVE_BOOK_INPUT);

}

G_MODULE_EXPORT
void
on_rememberbook_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  	glob_t dirlist;
	int i;
    	gchar *bm_dir;
	gchar *globstring;
	gchar *xdg_dir=xfce_resource_save_location (XFCE_RESOURCE_CACHE,"/",TRUE);

	bm_dir = g_build_filename(xdg_dir,BOOKMARK_DIR,NULL);
	g_free(xdg_dir);
	
	globstring = g_strconcat(bm_dir,G_DIR_SEPARATOR_S,"*.bm.dbh",NULL);

	print_diagnostics("xfce/info",_("Book"),":\n",NULL);

	
	if (glob (globstring, GLOB_ERR, NULL, &dirlist) != 0) {
	   print_diagnostics("xfce/warning","Nothing found",NULL);
#ifdef DEBUG
           printf ("DBG:%s: no match\n", globstring);
#endif
	   
	} else {
	   print_diagnostics("nonverbose",_("Files found=")," ",NULL);
	   for (i = 0; i < dirlist.gl_pathc; i++){
	      gchar *p,*g=g_path_get_basename(dirlist.gl_pathv[i]);
	      if(!strstr(g,".bm.dbh")) continue;
	      p=strstr(g,".bm.dbh");
	      *p=0;
	      print_diagnostics("nonverbose",g,(i == dirlist.gl_pathc-1)?
			      "\n":", ",NULL);
#ifdef DEBUG
              /*printf ("DBG:glob match: %s\n", dirlist.gl_pathv[i]);*/
              printf ("DBG:glob match: %s\n", g);
	      
#endif
	      g_free(g);g=NULL;
	   }
	}
  	globfree (&dirlist);

}

