/*
 * Copyright (C) 2002 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <limits.h>
#include <errno.h>

#include <gtk/gtk.h>

#ifdef XFCE_SUPPORT
#include <libxfcegui4/libxfcegui4.h>
#include <libxfce4mcs/mcs-client.h>
#endif


#include "glade_gui.h"
#include "glade_support.h"

#include "constants.h"
#include "types.h"

#include "add_node_contents.h"
#include "icons.h"
#include "misc.h"
#include "options.h"
#include "settings.h"

#define CHANNEL  "xffm"

extern GtkTreeView *main_treeview;
extern gchar *xffm_argv0;
 

extern gchar *env_string[];
extern char *env_vars[];

void init_xffm_env(void){
	int i;
	for (i=0;env_vars[i];i++)
		env_string[i]=NULL;
	return;
}

void xffm_setenv(GtkTreeView *treeview,const char *name,
		char *value,gboolean verbose){
  int which;
  gboolean go_ahead=FALSE;
  for (which=0;env_vars[which];which++)
	    if (strcmp(name,env_vars[which]) == 0) break;
  if (!env_vars[which]) return;
  if (!value || !strlen(value)) {
	  /*printf("DBG: erasing %s\n",name);*/
        g_free(env_string[which]);
/* environment handling is a blast:
 * freebsd only clears environment with unsetenv, not putenv
 * */
	
#ifdef HAVE_SETENV
	unsetenv(name);
        env_string[which]=NULL;
#else
        env_string[which]= g_strconcat(name,"=",NULL);
        putenv(env_string[which]);	
#endif
	
  	if (treeview && strcmp(xffm_argv0,"xffm")==0){
	   tree_entry_t *en;
	   GtkTreeIter iter;
           if (verbose){		   
	     if (strcmp(name, "SMB_USER") == 0) 
		     print_diagnostics(main_treeview,"xf_INFO_ICON",
				  name," ",_("changed"),
				  /*": ",
				  _("please refresh SMB Network"),*/
				  "\n",NULL);
	     else 
		     print_diagnostics(main_treeview,"xf_INFO_ICON",
				  name,"=",value?value:" ",
				  "\n",NULL);
	   }
	   if (strcmp(xffm_argv0,"xffm")==0){
	    if (strcmp(name, "XFFM_HIDE_LOCAL") == 0)
	     get_local_root(main_treeview,&iter,&en);
	    if (strcmp(name, "XFFM_HIDE_BOOK") == 0)
	     get_bookmark_root(main_treeview,&iter,&en);
	    if (strcmp(name, "XFFM_HIDE_NETWORK") == 0)
	     get_network_root(main_treeview,&iter,&en);
	    if (strcmp(name, "XFFM_HIDE_APPS") == 0)
	     get_apps_root(main_treeview,&iter,&en);
	    if (strcmp(name, "XFFM_HIDE_FIND") == 0)
	     get_find_root(main_treeview,&iter,&en);
	    if (strcmp(name, "XFFM_HIDE_TRASH") == 0)
	     get_trash_root(main_treeview,&iter,&en);
#if defined(HAVE_GETMNTENT) || defined(HAVE_GETFSENT) || defined(HAVE_GETVFSENT)
	    if (strcmp(name, "XFFM_HIDE_FSTAB") == 0)
	     get_fstab_root(main_treeview,&iter,&en);
#endif
	   }
	}
	return;
  }
  if (strcmp(name, "XFFM_STATUS_LINE_LENGTH")==0 || 
	  strcmp(name, "XFFM_MAX_PREVIEW_SIZE")==0)
  {
        if (is_number(value)) go_ahead=TRUE;
  } else if (strcmp(name, "TERM")==0) {
	  /*if (getenv(name) && access(getenv(name),X_OK)==0)*/
	  /*printf("DBG:TERM=%s!\n",value);*/

	  if (value && strlen(value)){
		gchar *c,*t=g_strdup(value);
    		t=g_strstrip(t);
		if (strchr(t,' '))t=strtok(t," ");
		c=g_find_program_in_path(t);
		if (c && access(c,X_OK)==0) {
		  go_ahead=TRUE;
      		}
  		g_free(c);
		g_free(t);
	  }
  }
  else go_ahead=TRUE;
  if (go_ahead){
     	  g_free(env_string[which]);
	  if (strcmp(name,"SMB_USER") == 0 && !strchr(value,'%')) {
             env_string[which]= g_strconcat(name,"=",value,"%",NULL);		
	  } else {
             env_string[which]= g_strconcat(name,"=",value,NULL);
	  }
          putenv(env_string[which]);
	  /*printf("DBG: mapping %s=%s\n",name,value);*/
	  if (treeview && strcmp(xffm_argv0,"xffm")==0){ 
		   if (verbose){		   
		     if (strcmp(name, "SMB_USER") == 0) 
			     print_diagnostics(main_treeview,"xf_INFO_ICON",
					  name," ",_("changed"),
					  /*": ",
					   _("please refresh SMB Network"),*/
					  "\n",NULL);
		     else 
			     print_diagnostics(main_treeview,"xf_INFO_ICON",
					  name,"=",value,
					  "\n",NULL);
		   }
	   if (strcmp(xffm_argv0,"xffm")==0){
		   if (strcmp(name, "XFFM_HIDE_BOOK") == 0){
		     erase_bookmark_root(main_treeview);
		   }
		   if (strcmp(name, "XFFM_HIDE_LOCAL") == 0){
		     erase_local_root(main_treeview);
		   }
		   if (strcmp(name, "XFFM_HIDE_NETWORK") == 0){
		     erase_network_root(main_treeview);
		   }
		   if (strcmp(name, "XFFM_HIDE_APPS") == 0){
		     erase_apps_root(main_treeview);
		   } 
		   if (strcmp(name, "XFFM_HIDE_FIND") == 0){
		     erase_find_root(main_treeview);
		   } 
		   if (strcmp(name, "XFFM_HIDE_TRASH") == 0){
		     erase_trash_root(main_treeview);
		   }
#if defined(HAVE_GETMNTENT) || defined(HAVE_GETFSENT) || defined(HAVE_GETVFSENT)
		   if (strcmp(name, "XFFM_HIDE_FSTAB") == 0){
		     erase_fstab_root(main_treeview);
		   }
#endif
	   }
	  } /* end if(treeview) */
  } else { /* not go_ahead */
           if (treeview && verbose && strcmp(xffm_argv0,"xffm")==0) 
 	     print_diagnostics(main_treeview,"xf_ERROR_ICON",
			  strerror(EINVAL),":",name,
			  "=",value?value:" ",
			  "\n",NULL);
  } 
  return;	  
}

#ifdef XFCE_SUPPORT

static gboolean active_mcs = TRUE;

static McsClient *client = NULL;

void set_active_mcs(gboolean state)
{
    active_mcs = state;
}

static GdkFilterReturn client_event_filter(GdkXEvent * xevent, GdkEvent * event, gpointer data)
{
    if(mcs_client_process_event(client, (XEvent *) xevent))
	return GDK_FILTER_REMOVE;
    else
	return GDK_FILTER_CONTINUE;
}

static void watch_cb(Window window, Bool is_start, long mask, void *cb_data)
{
    GdkWindow *gdkwin;

    gdkwin = gdk_window_lookup(window);

    if(is_start)
    {
	if(!gdkwin)
	{
	    gdkwin = gdk_window_foreign_new(window);
	}
	else
	{
	    g_object_ref(gdkwin);
	}
	gdk_window_add_filter(gdkwin, client_event_filter, cb_data);
    }
    else
    {
	g_assert(gdkwin);
	gdk_window_remove_filter(gdkwin, client_event_filter, cb_data);
	g_object_unref(gdkwin);
    }
}



static void notify_cb(const char *name, const char *channel_name, McsAction action, McsSetting * setting, void *data)
{
    tree_details_t *tree_details;
    if (main_treeview) tree_details = get_tree_details(main_treeview);
    else tree_details=NULL;

    if(!active_mcs)
	return;
    if(g_ascii_strcasecmp(CHANNEL, channel_name))
    {
	g_message("This should not happen");
	return;
    }

    switch (action)
    {
	case MCS_ACTION_NEW:
		/*printf("DBG:MCS_ACTION_NEW with name=%s \n",name);*/
	case MCS_ACTION_CHANGED:
		/*printf("DBG: MCS_ACTION_CHANGED with name=%s \n",name);*/
	    if(setting->type == MCS_TYPE_STRING)
	    {
		   int which;
		/*printf("DBG:notify_cb with name=%s value=%s\n",
		   name,setting->data.v_string); */
#if 0
		if(strcmp(name, "theme") == 0)
		{
		    g_free(xffm_theme);
		    xffm_theme=g_strdup(setting->data.v_string);	
		    if(tree_details){
			g_free(tree_details->theme);
			tree_details->theme=g_strdup(xffm_theme);
		    	recreate_icons(tree_details);
		    }
		}
#endif
		/* environment on the fly */
		if (!setting->data.v_string || 
		    !strlen(setting->data.v_string)){
		   xffm_setenv(main_treeview,name,NULL,TRUE);
		}
		else 
		  xffm_setenv(main_treeview,name,setting->data.v_string,TRUE);
		  
	       	/*printf("DBG: environment %s\n",env_string[which]);
		   printf("DBG:getenv=%s\n",getenv(name));*/
	
	    }
	    if(setting->type == MCS_TYPE_INT && tree_details)
	    {
#if 0
		if(strcmp(name, "icon_size") == 0)
		{
		    xffm_icon_size = setting->data.v_int;
		    if (tree_details){
		      tree_details->icon_size = setting->data.v_int;
		      reset_icons(tree_details);
		    }
		}
#endif		
#if 0
		/* screwy... */
		if(strcmp(name, "preferences") == 0)
		{
		    unsigned flag = tree_details->preferences ^ setting->data.v_int;
		    flag &= PREFERENCE_MASK;
		    if(flag)
			toggle_preference((GtkMenuItem *) tree_details->window, (gpointer) ((long)flag));
		}
#endif

	    }
	    break;
	case MCS_ACTION_DELETED:
		/*printf("DBG:  MCS_ACTION_DELETED with name=%s \n",name);*/
	default:
	    break;
    }
}

void connect_mcs(void)
{
    client = mcs_client_new(GDK_DISPLAY(), XDefaultScreen(GDK_DISPLAY()), notify_cb, watch_cb, NULL);
    if(client)
    {
	mcs_client_add_channel(client, CHANNEL);
    }
    else
    {
	g_warning("Cannot create MCS client channel");
    }
}

#endif
