/*
 * Archivo main.c inicial generado por Glade. Edítelo como
 * lo necesite, Glade nunca sobreescribirá este archivo.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif
#ifdef HAVE_SYS_STAT_H
#include <sys/stat.h>
#endif

#include <glob.h>
#ifdef HAVE_SYS_LIMITS_H
#include <limits.h>
#endif
#ifdef HAVE_MEMORY_H
#include <memory.h>
#endif
#ifdef HAVE_SIGNAL_H
#include <signal.h>
#endif
#include <stdio.h>
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include <gtk/gtk.h>

#ifdef XFCE_SUPPORT
#include <libxfce4util/i18n.h>
#include <libxfce4util/util.h>
#endif

#include "glade_gui.h"
#include "glade_support.h"

#include "constants.h"
#include "types.h"

#include "xmcs-manager.h"

#include "settings.h"
#include "misc.h"
#include "treeview.h"

GtkTreeView *main_treeview=NULL;
gchar *xffm_argv0;
gchar *xffm_argv1=NULL;
gchar *bookfile=NULL;
GList *theme_list=NULL;


static void finishit(int sig)
{
    if(sig == SIGUSR1)
    {
	/*g_timeout_add_full(0, 260, (GtkFunction) open_warning, NULL, NULL); */
	return;
    }
    else
    {
	fprintf(stderr, "xffm: signal %d received. Cleaning up before exiting\n", sig);
	cleanup_tmpfiles();
	exit(1);
    }
}

int main(int argc, char *argv[])
{
    char path[_POSIX_PATH_MAX];
    tree_details_t *tree_details;

#ifndef XFCE_SUPPORT
#ifdef ENABLE_NLS
    bindtextdomain(GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
#ifdef HAVE_BIND_TEXTDOMAIN_CODESET
    bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
#endif
    textdomain(GETTEXT_PACKAGE);
#endif
#else
    xfce_textdomain(GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR, "UTF-8");
#endif

    disable_diagnostics();

    gtk_set_locale();
    gtk_init(&argc, &argv);

    init_xffm_env();
 
#if 0
    client_session = client_session_new(argc, argv, NULL /* data */ , SESSION_RESTART_IF_RUNNING, 60);
    if(!session_init(client_session))
    {
	g_message("Cannot connect to session manager");
    }
#endif

    {
#ifdef HAVE_SIGACTION
	struct sigaction act;
	act.sa_handler = finishit;
	sigemptyset(&act.sa_mask);
#ifdef SA_RESTART
	act.sa_flags = SA_RESTART;
#else
	act.sa_flags = 0;
#endif
	sigaction(SIGHUP,&act,NULL);
	sigaction(SIGINT,&act,NULL);
	sigaction(SIGQUIT,&act,NULL);
	sigaction(SIGABRT,&act,NULL);
	sigaction(SIGBUS,&act,NULL);
	sigaction(SIGSEGV,&act,NULL);
	sigaction(SIGTERM,&act,NULL);
	sigaction(SIGFPE,&act,NULL);
	sigaction(SIGKILL,&act,NULL);
	sigaction(SIGUSR1,&act,NULL);
	sigaction(SIGUSR2,&act,NULL);
#else
	signal(SIGHUP, finishit);
	signal(SIGINT, finishit);
	signal(SIGQUIT, finishit);
	signal(SIGABRT, finishit);
	signal(SIGBUS, finishit);
	signal(SIGSEGV, finishit);
	signal(SIGTERM, finishit);
	signal(SIGFPE, finishit);
	signal(SIGKILL, finishit);
	signal(SIGUSR1, finishit);
	signal(SIGUSR2, finishit);
#endif
    }
 
    {
	struct stat st;
#ifndef XFCE_SUPPORT
	gchar *g;
	g=g_strconcat(g_get_home_dir(),"/.xfce4");
	strncpy(path,g, _POSIX_PATH_MAX-1);
	g_free(g);
#else
	strncpy(path, xfce_get_userdir(), _POSIX_PATH_MAX-1);
#endif
	path[_POSIX_PATH_MAX-1]=0;
	if(stat(path, &st) < 0)
	{
	    if(mkdir(path, 0770) < 0)
	    {
		printf("xffm: cannot write to %s\n", path);
		g_assert_not_reached();
	    }
	}

	xfce_get_userfile_r(path, _POSIX_PATH_MAX-1, "xffm"); 
	if(stat(path, &st) < 0)
	{
	    if(mkdir(path, 0770) < 0)
	    {
		printf("xffm: cannot write to %s\n", path);
		g_assert_not_reached();
	    }
	}
    }

    snprintf(path, _POSIX_PATH_MAX - 1, "%s/%s/pixmaps", PACKAGE_DATA_DIR, PACKAGE);
    add_pixmap_directory(path);
    {
	char **themes, **t;
	t = themes = find_themes(PACKAGE_DATA_DIR "/" PACKAGE "/pixmaps");
	for(t = themes; *t; t++)
	{
#ifdef DEBUG
	    printf("DBG: theme=%s\n",*t);  
#endif
	    /*snprintf(path, _POSIX_PATH_MAX - 1, "%s/%s/pixmaps/%s", 
	        PACKAGE_DATA_DIR, PACKAGE, *t);
	    add_pixmap_directory(path);*/
	    theme_list=g_list_append(theme_list,*t);
	}
	g_free(themes);
    }

    {
	int i;
	for(i = 0; i < argc; i++)
	    if(strcmp(argv[i], "--version") == 0)
	    {
		printf("%s version %s\nCopywrite Edscott Wilson Garcia, GPL\n", PACKAGE, VERSION);
		exit(1);
	    }

    }
/* how were we called? */
    {
      if(strrchr(argv[0],'/')) xffm_argv0=strrchr(argv[0],'/')+1;
      else xffm_argv0=argv[0];
      if (strncmp(xffm_argv0,"lt-",strlen("lt-"))==0) xffm_argv0 += strlen("lt-");
      /*printf("DBG: program is (%s)\n",xffm_argv0);*/
      if (strcmp(xffm_argv0,"xffm")!=0){
         xffm_setenv(NULL,"XFFM_HIDE_BOOK","yes",FALSE);
         xffm_setenv(NULL,"XFFM_HIDE_LOCAL","yes",FALSE);
         xffm_setenv(NULL,"XFFM_HIDE_NETWORK","yes",FALSE);
         xffm_setenv(NULL,"XFFM_HIDE_APPS","yes",FALSE);
         xffm_setenv(NULL,"XFFM_HIDE_FIND","yes",FALSE);
         xffm_setenv(NULL,"XFFM_HIDE_TRASH","yes",FALSE);
         xffm_setenv(NULL,"XFFM_HIDE_FSTAB","yes",FALSE);	      
      }
      if (strstr(xffm_argv0,"xfbook")){ 
	      xffm_setenv(NULL,"XFFM_HIDE_BOOK",NULL,FALSE);
	      if (argc >= 2) {
		      gchar *g=g_path_get_basename(argv[1]);
		      if (g && strlen(g)){
		        bookfile=g;
#ifdef DEBUG
		        printf("DBG:using %s\n",bookfile);
#endif
		      } else {
			g_free(g);
		      }
	      }
      }
      if (strstr(xffm_argv0,"xftree")) 
	      xffm_setenv(NULL,"XFFM_HIDE_LOCAL",NULL,FALSE);
      if (strstr(xffm_argv0,"xfsamba")) 
	      xffm_setenv(NULL,"XFFM_HIDE_NETWORK",NULL,FALSE);
      if (strstr(xffm_argv0,"xfapps")) 
	      xffm_setenv(NULL,"XFFM_HIDE_APPS",NULL,FALSE);
      if (strstr(xffm_argv0,"xfglob")) 
	      xffm_setenv(NULL,"XFFM_HIDE_FIND",NULL,FALSE);
      if (strstr(xffm_argv0,"xftrash")) 
	      xffm_setenv(NULL,"XFFM_HIDE_TRASH",NULL,FALSE);
      if (strstr(xffm_argv0,"xffstab")) 
	      xffm_setenv(NULL,"XFFM_HIDE_FSTAB",NULL,FALSE);
    }
    if (getenv("TERM")  && strlen( getenv("TERM")) && access(getenv("TERM"),X_OK)!=0)
	      xffm_setenv(NULL,"TERM",NULL,FALSE);

    /*printf("DBG:init_xffm\n");*/
    main_treeview = init_xffm(argc, argv);
    tree_details = get_tree_details(main_treeview);

#ifdef XFCE_SUPPORT
    connect_mcs();
#endif
    /*printf("DBG: mcs connected\n");   */

#if defined(HAVE_GETMNTENT) || defined(HAVE_GETFSENT) || defined(HAVE_GETVFSENT)
    if (strstr(xffm_argv0,"xffstab") && argc >= 2) {
	int go_to(GtkTreeView * treeview, char *path);
	int fstab_mount(GtkTreeView *treeview, char *mnt_point, gboolean umnt);
	int is_mounted(char *mnt_point);
	xffm_argv1=g_strdup(argv[1]);
	if (!is_mounted(xffm_argv1)){   
	   go_to(main_treeview,xffm_argv1);
	   fstab_mount(main_treeview, xffm_argv1,FALSE);
	}else{
	   go_to(main_treeview,xffm_argv1);
	}
    }
#endif

    enable_diagnostics();
    hide_text(tree_details->window);

    gtk_main();
    

    
    return 0;
}
