/*  xfce4
 *  Copyright (C) 2002 Jasper Huijsmans (huysmans@users.sourceforge.net)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <gdk/gdk.h>
#include <gtk/gtkbutton.h>
#include <gtk/gtkimage.h>

#include "xfce_iconbutton.h"

/* Forward declarations */

static void xfce_iconbutton_class_init (XfceIconbuttonClass * class);
static void xfce_iconbutton_init (XfceIconbutton * iconbutton);
static void xfce_iconbutton_finalize (GObject * object);
static void xfce_iconbutton_size_allocate_cb (GtkWidget * widget,
					      GtkAllocation * allocation,
					      XfceIconbutton * iconbutton);
static void xfce_iconbutton_scale (XfceIconbutton * iconbutton, int width,
				   int height);

/* Local data */

static GtkWidgetClass *parent_class = NULL;

GtkType
xfce_iconbutton_get_type (void)
{
    static GtkType iconbutton_type = 0;

    if (!iconbutton_type)
    {
	static const GTypeInfo iconbutton_info = {
	    sizeof (XfceIconbuttonClass),
	    NULL,		/* base_init */
	    NULL,		/* base_finalize */
	    (GClassInitFunc) xfce_iconbutton_class_init,
	    NULL,		/* class_finalize */
	    NULL,		/* class_data */
	    sizeof (XfceIconbutton),
	    0,			/* n_preallocs */
	    (GInstanceInitFunc) xfce_iconbutton_init
	};

	iconbutton_type =
	    g_type_register_static (GTK_TYPE_BUTTON, "XfceIconbutton",
				    &iconbutton_info, 0);
    }

    return iconbutton_type;
}

static void
xfce_iconbutton_class_init (XfceIconbuttonClass * class)
{
    GObjectClass *gobject_class = G_OBJECT_CLASS (class);
    GtkObjectClass *object_class;
    GtkWidgetClass *widget_class;

    object_class = (GtkObjectClass *) class;
    widget_class = (GtkWidgetClass *) class;
    gobject_class = G_OBJECT_CLASS (class);

    parent_class = gtk_type_class (gtk_button_get_type ());

    gobject_class->finalize = xfce_iconbutton_finalize;
}

static void
xfce_iconbutton_init (XfceIconbutton * iconbutton)
{
    iconbutton->image = gtk_image_new ();
    gtk_widget_show (iconbutton->image);
    gtk_container_add (GTK_CONTAINER (iconbutton), iconbutton->image);

    g_signal_connect (iconbutton->image, "size-allocate",
		      G_CALLBACK (xfce_iconbutton_size_allocate_cb),
		      iconbutton);

    iconbutton->pb = NULL;
    iconbutton->scaled = FALSE;
}

GtkWidget *
xfce_iconbutton_new (void)
{
    return GTK_WIDGET (g_object_new (xfce_iconbutton_get_type (), NULL));
}

GtkWidget *
xfce_iconbutton_new_from_pixbuf (GdkPixbuf * pixbuf)
{
    GtkWidget *iconbutton;

    iconbutton = xfce_iconbutton_new ();
    xfce_iconbutton_set_pixbuf (XFCE_ICONBUTTON (iconbutton), pixbuf);

    return iconbutton;
}

void
xfce_iconbutton_set_pixbuf (XfceIconbutton * iconbutton, GdkPixbuf * pixbuf)
{
    g_return_if_fail (iconbutton != NULL);
    g_return_if_fail (XFCE_IS_ICONBUTTON (iconbutton));

    if (iconbutton->pb)
	g_object_unref (iconbutton->pb);

    iconbutton->pb = pixbuf;
    g_object_ref (iconbutton->pb);

    gtk_image_set_from_pixbuf (GTK_IMAGE (iconbutton->image), iconbutton->pb);
}

static void
xfce_iconbutton_finalize (GObject * object)
{
    XfceIconbutton *iconbutton;

    g_return_if_fail (object != NULL);
    g_return_if_fail (XFCE_IS_ICONBUTTON (object));

    iconbutton = XFCE_ICONBUTTON (object);

    if (iconbutton->pb)
    {
	g_object_unref (iconbutton->pb);
	iconbutton->pb = NULL;
    }

    G_OBJECT_CLASS (parent_class)->finalize (object);
}

static void
xfce_iconbutton_size_allocate_cb (GtkWidget * widget,
				  GtkAllocation * allocation,
				  XfceIconbutton * iconbutton)
{
    /* prevent race condition */
    if (!iconbutton->scaled)
    {
	xfce_iconbutton_scale (iconbutton, allocation->width,
			       allocation->height);
	iconbutton->scaled = TRUE;
    }
    else
    {
	iconbutton->scaled = FALSE;
    }
}

static void
xfce_iconbutton_scale (XfceIconbutton * iconbutton, int width, int height)
{
    GdkPixbuf *tmp;
    float wratio, hratio;
    int w, h, pw, ph;

    g_return_if_fail (iconbutton != NULL);
    g_return_if_fail (XFCE_IS_ICONBUTTON (iconbutton));
    g_return_if_fail (iconbutton->pb != NULL);
    g_return_if_fail (GDK_IS_PIXBUF (iconbutton->pb));

    pw = gdk_pixbuf_get_width (iconbutton->pb);
    ph = gdk_pixbuf_get_height (iconbutton->pb);

    w = width <= 0 ? pw + 1 : width;
    h = height <= 0 ? ph + 1 : height;

    wratio = (float) pw / (float) w;
    hratio = (float) ph / (float) h;
/*
    g_printerr("w = %d, h = %d, pw = %d, ph = %d\n", w, h, pw, ph);
    g_printerr("wratio = %f, hratio = %f\n", wratio, hratio);
*/
    if (wratio <= 1.0 && hratio <= 1.0)
    {
	/* don't scale up -> ugly icons */
	gtk_image_set_from_pixbuf (GTK_IMAGE (iconbutton->image),
				   iconbutton->pb);
	return;
    }
    else if (wratio > hratio)
    {
	h = (float) ph / wratio;
    }
    else if (hratio > wratio)
    {
	w = (float) pw / hratio;
    }

    tmp = gdk_pixbuf_scale_simple (iconbutton->pb, w, h, GDK_INTERP_BILINEAR);
    gtk_image_set_from_pixbuf (GTK_IMAGE (iconbutton->image), tmp);
    g_object_unref (tmp);
}
