/*
 * Copyright (C) 2002-4 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <limits.h>
#include <errno.h>

#include <gtk/gtk.h>

#include <libxfce4util/i18n.h>
#include <libxfcegui4/libxfcegui4.h>
#include <libxfce4mcs/mcs-client.h>


/*#include "glade_support.h"*/

#include "constants.h"
#include "types.h"

#include "icons.h"
#include "misc.h"
#include "options.h"
#include "settings.h"

#define CHANNEL  "xffm"

 

extern gchar *env_string[];
extern char *env_vars[];

static int settings_cb_id = 0;

/* icon theme */
#if GTK_CHECK_VERSION (2,4,0)
static void
icontheme_cb (GtkIconTheme *icontheme)
{
#else /* gtk < 2.4 */
static void
settings_notify_cb (GtkSettings *gsettings, GParamSpec *pspec)
{
    if (strcmp (pspec->name, "gtk-icon-theme-name")) return;
#endif
    toggle_theme(NULL,NULL);
    print_diagnostics("xfce/info",_("Change"),":",_("Themes"),"\n",_("Restart application for changes to take effect"),"\n",NULL);
}



G_MODULE_EXPORT
void init_xffm_env(void){
	int i;
	for (i=0;env_vars[i];i++)
		env_string[i]=NULL;
	return;
}

G_MODULE_EXPORT
void xffm_setenv(const char *name,
		char *value,gboolean verbose){
  int which;
  gboolean go_ahead=FALSE;
  for (which=0;env_vars[which];which++)
	    if (strcmp(name,env_vars[which]) == 0) break;
  if (!env_vars[which]) return;
  if (!value || !strlen(value)) {
	  /*printf("DBG: erasing %s\n",name);*/
        g_free(env_string[which]);
	env_string[which]=NULL;
/* environment handling is a blast:
 * freebsd only clears environment with unsetenv, not putenv
 * */
	
#ifdef HAVE_SETENV
	unsetenv(name);
        env_string[which]=NULL;
#else
        env_string[which]= g_strconcat(name,"=",NULL);
        putenv(env_string[which]);	
#endif
	
  	/*if (treeview && strcmp(tree_details->argv[0],"xffm")==0){*/
  	if (tree_details->window){
           if (verbose){	
	     if (strcmp(name, "SMB_USER") == 0) {
		    gchar *m=g_strdup_printf(_("%s changed: please refresh SMB Network"),name);  
		    print_diagnostics("xfce/info",m, "\n",NULL);
		    g_free(m);
	     }
	     else 
		    print_diagnostics("xfce/info", name,"=",value?value:" ", "\n",NULL);
	   }
	}
	return;
  }
  if (strcmp(name, "XFFM_STATUS_LINE_LENGTH")==0 || 
	  strcmp(name, "XFFM_MAX_PREVIEW_SIZE")==0)
  {
        if (is_number(value)) go_ahead=TRUE;
  } else if (strcmp(name, "TERMCMD")==0) {
	  /*if (getenv(name) && access(getenv(name),X_OK)==0)*/
	  /*printf("DBG:TERMCMD=%s!\n",value);*/

	  if (value && strlen(value)){
		gchar *c,*t=g_strdup(value);
    		t=g_strstrip(t);
		if (strchr(t,' '))t=strtok(t," ");
		c=g_find_program_in_path(t);
		if (c && access(c,X_OK)==0) {
		  go_ahead=TRUE;
      		}
  		g_free(c);
		c=NULL;
		g_free(t);
		t=NULL;
	  }
  }
  else go_ahead=TRUE;
  if (go_ahead){
     	  g_free(env_string[which]);
	  env_string[which]=NULL;
	  if (strcmp(name,"SMB_USER") == 0 && !strchr(value,'%')) {
             env_string[which]= g_strconcat(name,"=",value,"%",NULL);		
	  } else {
             env_string[which]= g_strconcat(name,"=",value,NULL);
	  }
          putenv(env_string[which]);
	  /*printf("DBG: mapping %s=%s\n",name,value);*/
	  /*if (treeview && strcmp(tree_details->argv[0],"xffm")==0){ */
	  if (tree_details->window){ 
		   if (verbose){		   
		     if (strcmp(name, "SMB_USER") == 0) {
			gchar *m=g_strdup_printf(_("%s changed: please refresh SMB Network"),name);  
		        print_diagnostics("xfce/info",m, "\n",NULL);
		        g_free(m);
		     }
		     else 
			     print_diagnostics("xfce/info", name,"=",value, "\n",NULL);
		   }
	  } /* end if(treeview) */
  } else { /* not go_ahead */
           /*if (treeview && verbose && strcmp(tree_details->argv[0],"xffm")==0) */
           if (tree_details->window && verbose) 
 	     print_diagnostics("xfce/error", strerror(EINVAL),":\n",name, "=",(value?value:" "), "\n",NULL);
  } 
  return;	  
}


static gboolean active_mcs = TRUE;

static McsClient *client = NULL;

G_MODULE_EXPORT
void set_active_mcs(gboolean state)
{
    active_mcs = state;
}

static GdkFilterReturn client_event_filter(GdkXEvent * xevent, GdkEvent * event, gpointer data)
{
    if(mcs_client_process_event(client, (XEvent *) xevent))
	return GDK_FILTER_REMOVE;
    else
	return GDK_FILTER_CONTINUE;
}

static void watch_cb(Window window, Bool is_start, long mask, void *cb_data)
{
    GdkWindow *gdkwin;

    gdkwin = gdk_window_lookup(window);

    if(is_start)
    {
	if(!gdkwin)
	{
	    gdkwin = gdk_window_foreign_new(window);
	}
	else
	{
	    g_object_ref(gdkwin);
	}
	gdk_window_add_filter(gdkwin, client_event_filter, cb_data);
    }
    else
    {
	g_assert(gdkwin);
	gdk_window_remove_filter(gdkwin, client_event_filter, cb_data);
	g_object_unref(gdkwin);
    }
}



static void notify_cb(const char *name, const char *channel_name, McsAction action, McsSetting * setting, void *data)
{

    if(!active_mcs)
	return;
    if(g_ascii_strcasecmp(CHANNEL, channel_name))
    {
	g_message("This should not happen");
	return;
    }

    switch (action)
    {
	case MCS_ACTION_NEW:
		/*printf("DBG:MCS_ACTION_NEW with name=%s \n",name);*/
	case MCS_ACTION_CHANGED:
		/*printf("DBG: MCS_ACTION_CHANGED with name=%s \n",name);*/
	    if(setting->type == MCS_TYPE_STRING)
	    {
		/* environment on the fly */
		if (!setting->data.v_string || 
		    !strlen(setting->data.v_string)){
		   xffm_setenv(name,NULL,TRUE);
		}
		else 
		  xffm_setenv(name,setting->data.v_string,TRUE);
		  
	       	/*printf("DBG: environment %s\n",env_string[which]);
		   printf("DBG:getenv=%s\n",getenv(name));*/
	
	    }
	    if(setting->type == MCS_TYPE_INT && tree_details)
	    {

	    }
	    break;
	case MCS_ACTION_DELETED:
		/*printf("DBG:  MCS_ACTION_DELETED with name=%s \n",name);*/
	default:
	    break;
    }
}

G_MODULE_EXPORT
void connect_mcs(void)
{
    /*gchar *theme;*/
    client = mcs_client_new(GDK_DISPLAY(), XDefaultScreen(GDK_DISPLAY()), notify_cb, watch_cb, NULL);
    if(client)
    {
	mcs_client_add_channel(client, CHANNEL);
    }
    else
    {
	g_warning("Cannot create MCS client channel");
    }
#if 0
    theme = NULL;
    g_object_get (G_OBJECT (gsettings), "gtk-icon-theme-name", &theme, NULL);
    
    if (theme)
    {
        /*xfce_set_icon_theme (theme);*/
	D(printf("DBG: theme from mcs: %s\n",theme);)
	if (!set_icon_theme(theme,FALSE)){
	    if (!set_icon_theme("Rodent",FALSE)){
		set_icon_theme("hicolor",FALSE);
	    }
	}
	g_free(theme);
    }
#endif 
#if GTK_CHECK_VERSION (2,4,0)
    settings_cb_id = 
	g_signal_connect (gtk_icon_theme_get_default (), "changed", 
			  G_CALLBACK (icontheme_cb), NULL);
#else
    {
      GtkSettings *gsettings = gtk_settings_get_default ();
      settings_cb_id = g_signal_connect (gsettings, "notify", 
	    			       G_CALLBACK (settings_notify_cb), NULL);
    }
#endif
}

G_MODULE_EXPORT
void
mcs_stop_watch (void)
{
    if (client)
    {
	mcs_client_destroy (client);
	
	client = NULL;
    }

    if (settings_cb_id)
    {
#if GTK_CHECK_VERSION (2,4,0)
	g_signal_handler_disconnect (gtk_icon_theme_get_default (), 
				     settings_cb_id);
#else
	g_signal_handler_disconnect (gtk_settings_get_default (), 
				     settings_cb_id);
#endif
	settings_cb_id = 0;
    }
}


