/**
   GtkPageSetup - Stores page setup information
*/
#ifndef XFC_GTK_PAPER_SIZE_HH
#define XFC_GTK_PAPER_SIZE_HH 1

#include <xfc/gtk/printpagesetup.hh>

namespace Xfc {
    namespace Gtk {
        /**
           A PageSetup object stores the page size, orientation and margins. 
           The idea is that you can get one of these from the page setup 
           dialog and then pass it to the PrintOperation when printing. 
           The benefit of splitting this out of the PrintSettings is that 
           these affect the actual layout of the page, and thus need to 
           be set long before user prints.

           The margins specified in this object are the "print margins", 
           i.e. the parts of the page that the printer cannot print on. 
           These are different from the layout margins that a word processor 
           uses; they are typically used to determine the minimal size 
           for the layout margins.

           To obtain a PageSetup use gtk_page_setup_new() to get the defaults, 
           or use run_page_setup_dialog() to show the page setup 
           dialog and receive the resulting page setup. 
        */
        class PrintPaperSize : public G::Object {
        public:
            PageOrientation get_orientation();
            void set_orientation( PageOrientation orientation);
            PaperSize* get_paper_size();
            void set_paper_size( GtkPaperSize *size );
            gdouble get_top_margin( GtkUnit unit);
            void set_top_margin( gdouble margin, GtkUnit unit);
            gdouble get_bottom_margin( GtkUnit unit);
            void set_bottom_margin( gdouble margin, GtkUnit unit);
            gdouble get_left_margin( GtkUnit unit);
            void set_left_margin( gdouble margin, GtkUnit unit);
            gdouble get_right_margin( GtkUnit unit);
            void set_right_margin( gdouble margin, GtkUnit unit);
            void set_paper_size_and_default_margins( PaperSize *size);
            gdouble get_paper_width( GtkUnit unit);
            gdouble get_paper_height( GtkUnit unit);
            gdouble get_page_width(GtkUnit unit);
            gdouble get_page_height( GtkUnit unit);

        };
    }
}

#endif
