#! /bin/sh

srcdir=`dirname $0`
test -z "$srcdir" && srcdir=.

ORIGDIR=`pwd`
PKG_NAME="XFC"
TEST_TYPE=-f
FILE=configure.ac

DIE=0

# Check that autogen.sh is being run in the top-level directory

test $TEST_TYPE $FILE || {
  echo "You must run this script in the top-level $PKG_NAME directory"
  exit 1
}

# Check that libtool 1.4 > is installed

have_libtool=false
if libtoolize --version < /dev/null > /dev/null 2>&1 ; then
  libtool_version=`libtoolize --version | sed 's/^[^0-9]*\([0-9.][0-9.]*\).*/\1/'`
  case $libtool_version in
    1.4*|1.5*|2.*)
  have_libtool=true
    ;;
  esac
fi
if $have_libtool ; then : ; else
  echo
  echo "You must have libtool 1.4 installed to compile $PKG_NAME."
  echo "Install the appropriate package for your distribution,"
  echo "or get the source tarball at http://ftp.gnu.org/gnu/libtool/"
  DIE=1
fi

# Check that automake is installed

(automake --version) < /dev/null > /dev/null 2>&1 || {
  echo
  echo "You must have automake installed to compile $PKG_NAME."
  echo "Install the appropriate package for your distribution,"
  echo "or get the source tarball at http://ftp.gnu.org/gnu/automake/"
}

# Check that autoconf is installed

(autoconf --version) < /dev/null > /dev/null 2>&1 || {
  echo
  echo "You must have autoconf installed to compile $PKG_NAME."
  echo "Install the appropriate package for your distribution,"
  echo "or get the source tarball at ftp://ftp.gnu.org/pub/gnu/autoconf"
  DIE=1
}

# Stop running this script if any of above checks failed

if test "$DIE" -eq 1; then
	exit 1
fi

if test -z "$AUTOGEN_SUBDIR_MODE"; then
  if test -z "$*"; then
    echo
    echo "You passed no ./configure arguments. I am going to run ./configure"
    echo "with --enable-maintainer-mode and --enable-docs arguments - if you"
    echo "wish to pass any to it, please specify them on the $0 command line."
    echo
  fi
fi

echo "Creating configuration files..."
aclocal $ACLOCAL_FLAGS || exit $?
libtoolize --automake --force --copy || exit $?
autoheader || exit $?

echo "Generating makefiles..."
automake --add-missing --copy || exit $?

echo "Generating configure script..."
autoconf || exit $?

rm -f config.cache

cd $ORIGDIR || exit $?

if test -z "$AUTOGEN_SUBDIR_MODE"; then
  echo "Running $srcdir/configure --enable-maintainer-mode --enable-docs"
  $srcdir/configure --enable-maintainer-mode --enable-docs "$@" || exit $?
fi

echo "Now type 'make' to compile $PKG_NAME."
echo 
