/*
 *  xfce4 mouse settings
 *
 *  Copyright (c) 2002 Olivier Fourdan
 *  Copyright (c) 2005 Pasi Orovuo <pasi.ov@gmail.com>
 *  Copyright (c) 2005 Brian Tarricone <bjt23@cornell.edu>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License ONLY.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __MOUSE_PLUGIN_INTERNAL_H__
#define __MOUSE_PLUGIN_INTERNAL_H__

#include <gtk/gtk.h>
#include <xfce-mcs-manager/manager-plugin.h>

#define RCDIR "mcs_settings"
#define OLDRCDIR "settings"
#define CHANNEL1 "settings"
#define RCFILE1 "gtk.xml"
#define CHANNEL2 "mouse"
#define RCFILE2 "mouse.xml"
#define PLUGIN_NAME "mouse"

typedef struct _Itf
{
    McsPlugin *mcs_plugin;

    GSList *radiobutton1_group;

    GtkWidget *mouse_dialog;
    GtkWidget *dialog_vbox1;
    GtkWidget *notebook_vbox;
    GtkWidget *notebook;
    
    /* mouse behavior tab */
    GtkWidget *vbox1;
    GtkWidget *frame1;
    GtkWidget *hbox2;
    GtkWidget *radiobutton1;
    GtkWidget *radiobutton2;
    GtkWidget *label1;
    GtkWidget *frame2;
    GtkWidget *table1;
    GtkWidget *label3;
    GtkWidget *label4;
    GtkWidget *hscale1;
    GtkWidget *label5;
    GtkWidget *label6;
    GtkWidget *label7;
    GtkWidget *hscale2;
    GtkWidget *label8;
    GtkWidget *label2;
    GtkWidget *frame3;
    GtkWidget *table2;
    GtkWidget *label11;
    GtkWidget *hscale3;
    GtkWidget *label12;
    GtkWidget *label10;
    GtkWidget *label9;
    GtkWidget *frame4;
    GtkWidget *table3;
    GtkWidget *label14;
    GtkWidget *label15;
    GtkWidget *label16;
    GtkWidget *hscale4;
    GtkWidget *label13;
    GtkWidget *dialog_action_area1;
    GtkWidget *closebutton1;
    
    /* cursor tab */
    GtkWidget *cursor_page;
    GtkWidget *cursor_theme_list;
    GtkWidget *cursor_preview_list;
    GtkWidget *cursor_size_spinbtn;
} Itf;

void mouse_plugin_set_initial_cursor_values(McsPlugin *mcs_plugin);
void mouse_plugin_create_cursor_page(Itf *itf);
gboolean mouse_plugin_write_options(McsPlugin *mcs_plugin);

#endif
