#ifndef __MODULES__H_
#define __MODULES__H_

#include <xfce4-modules/constants.h>
#include <xfce4-modules/combo.h>
#include <xfce4-modules/mime.h>
#include <xfce4-modules/mime_icons.h>

#include "../modules/properties.h"
#include "../modules/find.h"

#ifdef USE_SMB_BRANCH
#include "../smb/smb_module.h"
#endif	

void set_module_treeview(GtkTreeView *treeview);

/* private xffm modules: */
/* property module (could be made exportable easily) */
xfprop_functions *load_prop_module(void);
void unload_prop_module(void);

/* find module */
xffind_functions *load_find_module(void);
void unload_find_module(void);

#ifdef USE_SMB_BRANCH
/* smb module */
xfsmb_functions *load_smb_module(void);
void unload_smb_module(void);
#endif	


/* exportable modules: */
/* combo module: */
xfc_combo_functions *load_xfc(void);
void unload_xfc(void);

/* mime module */
xfmime_functions *load_mime_module(void);
void unload_mime_module(void);

/* mime_icon module */
xfmime_icon_functions *load_mime_icon_module(void);
void unload_mime_icon_module(void);


#endif

