/*
 * Copyright (c) 2003 Benedikt Meurer (benedikt.meurer@unix-ag.uni-siegen.de)
 *               2004 Jean-Franois Wauthy (pollux@xfce.org)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifdef	HAVE_CONFIG_H
#include <config.h>
#endif	/* !HAVE_CONFIG_H */

#include <string.h>
#include <gtk/gtk.h>

#include <libxfce4util/libxfce4util.h>

#include "head_page.h"

#ifndef HAVE_STRLCPY
#define	strlcpy		g_strlcpy
#endif

static void head_page_class_init(HeadPageClass *);
static void head_page_init(HeadPage *);
static void head_page_finalize(GObject *);

/* signal handlers */
static void toggled_cb(GtkToggleButton *, HeadPage *);

static GtkWidgetClass *parent_class = NULL;

GtkType
head_page_get_type(void)
{
	static GtkType head_page_type = 0;

	if (!head_page_type) {
		static const GTypeInfo head_page_info = {
			sizeof(HeadPageClass),
			NULL,
			NULL,
			(GClassInitFunc)head_page_class_init,
			NULL,
			NULL,
			sizeof(HeadPage),
			0,
			(GInstanceInitFunc)head_page_init
		};

		head_page_type = g_type_register_static(GTK_TYPE_TABLE,
			"HeadPage", &head_page_info, 0);
	}

	return(head_page_type);
}

static void
head_page_class_init(HeadPageClass *klass)
{
	GObjectClass *object_class;

	object_class = G_OBJECT_CLASS(klass);
	object_class->finalize = head_page_finalize;

	parent_class = gtk_type_class(gtk_table_get_type());
}

static void
head_page_init(HeadPage *pg)
{
	GtkWidget *label;

	gtk_container_set_border_width(GTK_CONTAINER(pg), 6);
	gtk_table_resize(GTK_TABLE(pg), 9, 2);
	gtk_table_set_col_spacings(GTK_TABLE(pg), 4);
	gtk_table_set_row_spacings(GTK_TABLE(pg), 4);
	gtk_table_set_homogeneous(GTK_TABLE(pg), FALSE);

	pg->headers = gtk_check_button_new_with_label(_("Print headers"));
	gtk_widget_show(pg->headers);
	g_signal_connect(G_OBJECT(pg->headers), "toggled",
		G_CALLBACK(toggled_cb), pg);
	gtk_table_attach(GTK_TABLE(pg), pg->headers, 0, 2, 0, 1,
		GTK_EXPAND | GTK_FILL, 0, 0, 0);

	label = gtk_label_new(_("Header:"));
	gtk_misc_set_alignment(GTK_MISC(label), 0, 0.5);
	gtk_widget_show(label);
	gtk_table_attach(GTK_TABLE(pg), label, 0, 1, 1, 2,
		GTK_FILL, 0, 0, 0);

	pg->header = gtk_entry_new();
	gtk_widget_show(pg->header);
	gtk_table_attach(GTK_TABLE(pg), pg->header, 1, 2, 1, 2,
		GTK_EXPAND | GTK_FILL, 0, 0, 0);

	label = gtk_label_new(_("Underlay:"));
	gtk_misc_set_alignment(GTK_MISC(label), 0, 0.5);
	gtk_widget_show(label);
	gtk_table_attach(GTK_TABLE(pg), label, 0, 1, 2, 3,
		GTK_FILL, 0, 0, 0);

	pg->underlay = gtk_entry_new();
	gtk_widget_show(pg->underlay);
	gtk_table_attach(GTK_TABLE(pg), pg->underlay, 1, 2, 2, 3,
		GTK_EXPAND | GTK_FILL, 0, 0, 0);

	label = gtk_label_new(_("Center title:"));
	gtk_misc_set_alignment(GTK_MISC(label), 0, 0.5);
	gtk_widget_show(label);
	gtk_table_attach(GTK_TABLE(pg), label, 0, 1, 3, 4,
		GTK_FILL, 0, 0, 0);

	pg->ctitle = gtk_entry_new();
	gtk_widget_show(pg->ctitle);
	gtk_table_attach(GTK_TABLE(pg), pg->ctitle, 1, 2, 3, 4,
		GTK_EXPAND | GTK_FILL, 0, 0, 0);

	label = gtk_label_new(_("Left title:"));
	gtk_misc_set_alignment(GTK_MISC(label), 0, 0.5);
	gtk_widget_show(label);
	gtk_table_attach(GTK_TABLE(pg), label, 0, 1, 4, 5,
		GTK_FILL, 0, 0, 0);

	pg->ltitle = gtk_entry_new();
	gtk_widget_show(pg->ltitle);
	gtk_table_attach(GTK_TABLE(pg), pg->ltitle, 1, 2, 4, 5,
		GTK_EXPAND | GTK_FILL, 0, 0, 0);

	label = gtk_label_new(_("Right title:"));
	gtk_misc_set_alignment(GTK_MISC(label), 0, 0.5);
	gtk_widget_show(label);
	gtk_table_attach(GTK_TABLE(pg), label, 0, 1, 5, 6,
		GTK_FILL, 0, 0, 0);

	pg->rtitle = gtk_entry_new();
	gtk_widget_show(pg->rtitle);
	gtk_table_attach(GTK_TABLE(pg), pg->rtitle, 1, 2, 5, 6,
		GTK_EXPAND | GTK_FILL, 0, 0, 0);

	label = gtk_label_new(_("Center footer:"));
	gtk_misc_set_alignment(GTK_MISC(label), 0, 0.5);
	gtk_widget_show(label);
	gtk_table_attach(GTK_TABLE(pg), label, 0, 1, 6, 7,
		GTK_FILL, 0, 0, 0);

	pg->cfooter = gtk_entry_new();
	gtk_widget_show(pg->cfooter);
	gtk_table_attach(GTK_TABLE(pg), pg->cfooter, 1, 2, 6, 7,
		GTK_EXPAND | GTK_FILL, 0, 0, 0);

	label = gtk_label_new(_("Left footer:"));
	gtk_misc_set_alignment(GTK_MISC(label), 0, 0.5);
	gtk_widget_show(label);
	gtk_table_attach(GTK_TABLE(pg), label, 0, 1, 7, 8,
		GTK_FILL, 0, 0, 0);

	pg->lfooter = gtk_entry_new();
	gtk_widget_show(pg->lfooter);
	gtk_table_attach(GTK_TABLE(pg), pg->lfooter, 1, 2, 7, 8,
		GTK_EXPAND | GTK_FILL, 0, 0, 0);

	label = gtk_label_new(_("Right footer:"));
	gtk_misc_set_alignment(GTK_MISC(label), 0, 0.5);
	gtk_widget_show(label);
	gtk_table_attach(GTK_TABLE(pg), label, 0, 1, 8, 9,
		GTK_FILL, 0, 0, 0);

	pg->rfooter = gtk_entry_new();
	gtk_widget_show(pg->rfooter);
	gtk_table_attach(GTK_TABLE(pg), pg->rfooter, 1, 2, 8, 9,
		GTK_EXPAND | GTK_FILL, 0, 0, 0);
}

static void
head_page_finalize(GObject *object)
{
	g_return_if_fail(object != NULL);
	g_return_if_fail(HEAD_IS_PAGE(object));

	G_OBJECT_CLASS(parent_class)->finalize(object);
}

GtkWidget *
head_page_new(void)
{
	HeadPage *pg;

	pg = HEAD_PAGE(g_object_new(head_page_get_type(), NULL));

	return(GTK_WIDGET(pg));
}

void
head_page_set_settings(HeadPage *pg, const XfprintSettingsHeadings *hd)
{
	g_return_if_fail(pg != NULL);
	g_return_if_fail(hd != NULL);

	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(pg->headers),
		hd->headers);

	/* XXX - GTK+ seems to be bogus bout the above */
	gtk_toggle_button_toggled(GTK_TOGGLE_BUTTON(pg->headers));

	gtk_entry_set_text(GTK_ENTRY(pg->header), hd->header);
	gtk_entry_set_text(GTK_ENTRY(pg->underlay), hd->underlay);
	gtk_entry_set_text(GTK_ENTRY(pg->ctitle), hd->ctitle);
	gtk_entry_set_text(GTK_ENTRY(pg->ltitle), hd->ltitle);
	gtk_entry_set_text(GTK_ENTRY(pg->rtitle), hd->rtitle);
	gtk_entry_set_text(GTK_ENTRY(pg->cfooter), hd->cfooter);
	gtk_entry_set_text(GTK_ENTRY(pg->lfooter), hd->lfooter);
	gtk_entry_set_text(GTK_ENTRY(pg->rfooter), hd->rfooter);
}

void
head_page_get_settings(HeadPage *pg, XfprintSettingsHeadings *hd)
{
	g_return_if_fail(pg != NULL);
	g_return_if_fail(hd != NULL);

	hd->headers = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(
			pg->headers));

	strlcpy(hd->header, gtk_entry_get_text(GTK_ENTRY(pg->header)),
			sizeof(hd->header));
	strlcpy(hd->underlay, gtk_entry_get_text(GTK_ENTRY(pg->underlay)),
			sizeof(hd->header));
	strlcpy(hd->ctitle, gtk_entry_get_text(GTK_ENTRY(pg->ctitle)),
			sizeof(hd->ctitle));
	strlcpy(hd->ltitle, gtk_entry_get_text(GTK_ENTRY(pg->ltitle)),
			sizeof(hd->ltitle));
	strlcpy(hd->rtitle, gtk_entry_get_text(GTK_ENTRY(pg->rtitle)),
			sizeof(hd->rtitle));
	strlcpy(hd->cfooter, gtk_entry_get_text(GTK_ENTRY(pg->cfooter)),
			sizeof(hd->cfooter));
	strlcpy(hd->lfooter, gtk_entry_get_text(GTK_ENTRY(pg->lfooter)),
			sizeof(hd->lfooter));
	strlcpy(hd->rfooter, gtk_entry_get_text(GTK_ENTRY(pg->rfooter)),
			sizeof(hd->rfooter));
}

static void
toggled_cb(GtkToggleButton *btn, HeadPage *pg)
{
	gboolean active;

	active = gtk_toggle_button_get_active(btn);

	gtk_widget_set_sensitive(pg->header, active);
	gtk_widget_set_sensitive(pg->underlay, active);
	gtk_widget_set_sensitive(pg->ctitle, active);
	gtk_widget_set_sensitive(pg->ltitle, active);
	gtk_widget_set_sensitive(pg->rtitle, active);
	gtk_widget_set_sensitive(pg->cfooter, active);
	gtk_widget_set_sensitive(pg->lfooter, active);
	gtk_widget_set_sensitive(pg->rfooter, active);
}

